% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.2x2.mean.bs}
\alias{ci.2x2.mean.bs}
\title{Computes tests and confidence intervals of effects in a 2x2 between-subjects
design for means}
\usage{
ci.2x2.mean.bs(alpha, y11, y12, y21, y22)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y11}{vector of scores at level 1 of A and level 1 of B}

\item{y12}{vector of scores at level 1 of A and level 2 of B}

\item{y21}{vector of scores at level 2 of A and level 1 of B}

\item{y22}{vector of scores at level 2 of A and level 2 of B}
}
\value{
Returns a 7-row matrix (one row per effect). The columns are:
\itemize{
\item Estimate - estimate of effect
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals and tests for the AB interaction effect,
main effect of A, main efect of B, simple main effects of A, and simple main
effects of B in a 2x2 between-subjects design with a quantitative response
variable. A Satterthwaite adjustment to the degrees of freedom is used and
equality of population variances is not assumed.
}
\examples{
y11 = c(14, 15, 11, 7, 16, 12, 15, 16, 10, 9)
y12 = c(18, 24, 14, 18, 22, 21, 16, 17, 14, 13)
y21 = c(16, 11, 10, 17, 13, 18, 12, 16, 6, 15)
y22 = c(18, 17, 11, 9, 9, 13, 18, 15, 14, 11)
ci.2x2.mean.bs(.05, y11, y12, y21, y22)

# Should return:
#          Estimate       SE           t       df           p         LL         UL
# AB:         -5.10 2.224860 -2.29227953 35.47894 0.027931810 -9.6145264 -0.5854736
# A:           1.65 1.112430  1.48323970 35.47894 0.146840430 -0.6072632  3.9072632
# B:          -2.65 1.112430 -2.38217285 35.47894 0.022698654 -4.9072632 -0.3927368
# A at b1:    -0.90 1.545244 -0.58243244 17.56296 0.567678242 -4.1522367  2.3522367
# A at b2:     4.20 1.600694  2.62386142 17.93761 0.017246053  0.8362274  7.5637726
# B at a1:    -5.20 1.536952 -3.38331916 17.61093 0.003393857 -8.4341379 -1.9658621
# B at a2:    -0.10 1.608657 -0.06216365 17.91650 0.951120753 -3.4807927  3.2807927


}
