% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.stdmean2}
\alias{size.ci.stdmean2}
\title{Sample size for a 2-group standardized mean difference confidence interval}
\usage{
size.ci.stdmean2(alpha, d, w, R)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{d}{planning value of standardized mean difference}

\item{w}{desired confidence interval width}

\item{R}{n2/n1 ratio}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group required to estimate a population
standardized mean difference with desired confidence interval precision
in a 2-group design. Set the standardized mean difference planning value
to the largest value within a plausible range for a conservatively large
sample size. Set R = 1 for equal sample sizes.
}
\examples{
size.ci.stdmean2(.05, .75, .5, 1)

# Should return:
#       n1   n2
# [1,] 132  132
 

}
\references{
\insertRef{Bonett2009}{statpsych}
}
