/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.DoubleArray;
import blbutil.FloatArray;
import ints.IntArray;
import ints.IntList;
import ints.WrappedIntArray;
import java.util.stream.IntStream;
import vcf.GT;
import vcf.MarkerMap;

public final class Ibs2Markers {
    private static final float MAX_MISS_FREQ = 0.1f;
    private static final float MIN_MINOR_FREQ = 0.05f;
    private static final int MIN_MARKER_CNT = 50;
    private static final float MIN_INTERMARKER_CM = 0.002f;
    private final Boolean[] useMarker;
    private final IntArray stepStarts;

    public Ibs2Markers(GT gT, MarkerMap markerMap, FloatArray floatArray, float f) {
        if (markerMap.genPos().size() != gT.nMarkers()) {
            throw new IllegalArgumentException(String.valueOf(markerMap.genPos().size()));
        }
        if (floatArray.size() != gT.nMarkers()) {
            throw new IllegalArgumentException(String.valueOf(floatArray.size()));
        }
        if ((double)f <= 0.0 || !Float.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        int n = (int)Math.ceil(0.1f * (float)gT.nHaps());
        Boolean[] booleanArray = (Boolean[])IntStream.range(0, gT.nMarkers()).parallel().mapToObj(n2 -> Ibs2Markers.useMarker(gT, n2, floatArray, n)).toArray(Boolean[]::new);
        this.stepStarts = Ibs2Markers.stepStarts(booleanArray, markerMap, f);
        this.useMarker = booleanArray;
    }

    private static Boolean useMarker(GT gT, int n, FloatArray floatArray, int n2) {
        int n3 = 0;
        if (floatArray.get(n) >= 0.05f) {
            int n4 = gT.nHaps();
            for (int i = 0; i < n4; ++i) {
                if (gT.allele(n, i) >= 0) continue;
                ++n3;
            }
            return n3 <= n2;
        }
        return false;
    }

    private static IntArray stepStarts(Boolean[] booleanArray, MarkerMap markerMap, float f) {
        DoubleArray doubleArray = markerMap.genPos();
        int n = doubleArray.size();
        IntList intList = new IntList(doubleArray.size() >> 6);
        int n2 = 0;
        int n3 = Ibs2Markers.nextStart(doubleArray, f, n2, booleanArray);
        while (n3 < n) {
            intList.add(n2);
            n2 = n3;
            n3 = Ibs2Markers.nextStart(doubleArray, f, n3, booleanArray);
        }
        return new WrappedIntArray(intList);
    }

    private static int nextStart(DoubleArray doubleArray, double d, int n, Boolean[] booleanArray) {
        int n2;
        double d2 = doubleArray.get(n);
        double d3 = d2 + d;
        double d4 = d2 + (double)0.002f;
        int n3 = 0;
        for (n2 = n + 1; n2 < booleanArray.length && (n3 < 50 || doubleArray.get(n2) < d3); ++n2) {
            if (!booleanArray[n2].booleanValue()) continue;
            d2 = doubleArray.get(n2);
            if (d2 < d4) {
                booleanArray[n2] = Boolean.FALSE;
                continue;
            }
            ++n3;
            d4 = d2 + (double)0.002f;
        }
        return n2;
    }

    public int nMarkers() {
        return this.useMarker.length;
    }

    public int[] markers(int n, int n2) {
        if (n < 0 || n2 > this.useMarker.length) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n2 > this.useMarker.length) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        IntList intList = new IntList(n2 - n);
        for (int i = n; i < n2; ++i) {
            if (!this.useMarker[i].booleanValue()) continue;
            intList.add(i);
        }
        return intList.toArray();
    }

    public IntArray stepStarts() {
        return this.stepStarts;
    }
}

