% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/bin.R
\name{bin}
\alias{bin}
\title{Bin a numeric vector and return integer codes for the binning (corresponds to Stata command xtile)}
\usage{
bin(x, cutpoints = NULL, probs = NULL, n_quantiles = NULL, w = NULL)
}
\arguments{
\item{x}{A vector}

\item{cutpoints}{Cutpoints to use when \code{nq} is not specified.  For instance \code{cutpoints = 0.4} creates two groups, one for observations equal or below 0.4, one for observations superior to 0.4.}

\item{probs}{A vector of probabilities that an be used instead of cutpoints. Quantiles are computed as the inverse of the empirical distribution function (type = 1)}

\item{n_quantiles}{A numeric specifying number of quantiles. Can be used instead of cutpoints}

\item{w}{A variable specifying weight in case the option n_quantiles is specified.}
}
\value{
An integer vector representing groups corresponding to cutpoints. Includes missing values when present in the original vector.
}
\description{
Bin a numeric vector and return integer codes for the binning (corresponds to Stata command xtile)
}
\examples{
v <- c(NA, 1:10)
bin(v, n_quantiles = 3) # 3 groups based on terciles
bin(v, probs = c(0.3, 0.7)) # 3 groups based on two quantiles
bin(v, cutpoints = c(2, 3)) # 3 groups based on two cutpoints
}

