% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssMRCD.R
\name{ssMRCD}
\alias{ssMRCD}
\title{Spatially Smoothed MRCD Estimator}
\usage{
ssMRCD(
  x,
  weights,
  lambda,
  TM = NULL,
  alpha = 0.75,
  maxcond = 50,
  maxcsteps = 200,
  n_initialhsets = NULL
)
}
\arguments{
\item{x}{a list of matrices containing the observations per neighborhood sorted which can be obtained by the function \code{\link[ssMRCD]{restructure_as_list}}.}

\item{weights}{weighting matrix, symmetrical, rows sum up to one and diagonals need to be zero (see also \code{\link[ssMRCD]{geo_weights}} or \code{\link[ssMRCD]{rescale_weights}} .}

\item{lambda}{numeric between 0 and 1.}

\item{TM}{target matrix (optional), default value is the covMcd from robustbase.}

\item{alpha}{numeric, proportion of values included, between 0.5 and 1.}

\item{maxcond}{optional, maximal condition number used for rho-estimation.}

\item{maxcsteps}{maximal number of c-steps before algorithm stops.}

\item{n_initialhsets}{number of initial h-sets, default is 6 times number of neighborhoods.}
}
\value{
An object of class \code{"ssMRCD"} containing the following elements:\tabular{ll}{
   \code{MRCDcov} \tab List of ssMRCD-covariance matrices sorted by neighborhood. \cr
   \tab \cr
   \code{MRCDicov} \tab List of inverse ssMRCD-covariance matrices sorted by neighborhood. \cr
   \tab \cr
   \code{MRCDmu} \tab List of ssMRCD-mean vectors sorted by neighborhood. \cr
   \tab \cr
   \code{mX} \tab List of data matrices sorted by neighborhood.\cr
   \tab \cr
   \code{N} \tab Number of neighborhoods. \cr
   \tab \cr
   \code{mT} \tab Target matrix. \cr
   \tab \cr
   \code{rho} \tab Vector of regularization values sorted by neighborhood. \cr
   \tab \cr
   \code{alpha} \tab Scalar what percentage of observations should be used. \cr
   \tab \cr
   \code{h} \tab Vector of how many observations are used per neighborhood, sorted. \cr
   \tab \cr
   \code{numiter} \tab The number of iterations for the best initial h-set combination. \cr
   \tab \cr
   \code{c_alpha} \tab Consistency factor for normality. \cr
   \tab \cr
   \code{weights} \tab The weighting matrix. \cr
   \tab \cr
   \code{lambda} \tab Smoothing factor. \cr
   \tab \cr
   \code{obj_fun_values} \tab A matrix with objective function values for all
initial h-set combinations (rows) and iterations (columns). \cr
   \tab \cr
   \code{best6pack} \tab initial h-set combinations with best objective function value
after c-step iterations. \cr
   \code{Kcov} \tab returns MRCD-estimates without smoothing. \cr
}
}
\description{
The ssMRCD function calculates the spatially smoothed MRCD estimator from Puchhammer and Filzmoser (2023).
}
\examples{
# create data set
x1 = matrix(runif(200), ncol = 2)
x2 = matrix(rnorm(200), ncol = 2)
x = list(x1, x2)

# create weighting matrix
W = matrix(c(0, 1, 1, 0), ncol = 2)

# calculate ssMRCD
ssMRCD(x, weights = W, lambda = 0.5)
}
\references{
Puchhammer P. and Filzmoser P. (2023): Spatially smoothed robust covariance estimation for local outlier detection. \doi{10.48550/arXiv.2305.05371}
}
\seealso{
\code{\link[ssMRCD]{plot.ssMRCD}, \link[ssMRCD]{summary.ssMRCD}, \link[ssMRCD]{restructure_as_list}}
}
