\name{sraStartingvalues}
\alias{sraStartingvalues}

\title{Provides reasonable starting values for sra model fit (internal function) }
\description{
  These functions aim at providing educated starting values for the parameters to estimate through sra models. 
}
\usage{
sraStartingvalues(parameter, sradata, rand=0)
}

\arguments{
  \item{parameter}{ A character string corresponding to the name of a parameter to consider, e.g. \code{"mu0"} or \code{"logepsilon"}. Depending on the parameter, starting values can be estimated from the dataset, or a reasonable arbitrary value may be returned. }
  \item{sradata}{ A data object generated by \code{\link{sraData}}. }
  \item{rand}{ Amount of randomness to add to the parameter value. Setting a value different from 0 leads to a different answer for each function call, which can be useful when trying different vectors of staring values to solve problematic convergence cases. In general, values > 0.2 provide starting values that are too extreme to be useful. }
}


\note{ The end user has no particular reason to call these functions directly. }

\seealso{ \code{\link{sraAutoreg}}, \code{\link{sraCstvar}}, and other mechanistic models. }

\keyword{ internal }
\keyword{ models }

