% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.inat.R
\name{as.inat}
\alias{as.inat}
\title{Coerce occurrence keys to iNaturalist id objects}
\usage{
as.inat(x, ...)
}
\arguments{
\item{x}{Various inputs, including the output from a call to
\code{\link[=occ]{occ()}} (class occdat), \code{\link[=occ2df]{occ2df()}} (class data.frame), or a list, numeric,
character, inatkey, or occkey.}

\item{...}{curl options; named parameters passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
One or more in a list of both class inatkey and occkey
}
\description{
Coerce occurrence keys to iNaturalist id objects
}
\examples{
\dontrun{
spnames <- c('Accipiter striatus', 'Setophaga caerulescens',
  'Spinus tristis')
out <- occ(query=spnames, from='inat', limit=2)
res <- occ2df(out)
(tt <- as.inat(out))
(uu <- as.inat(res))
as.inat(res$key[1])
as.inat(as.list(res$key[1:2]))
as.inat(tt[[1]])
as.inat(uu[[1]])
as.inat(tt[1:2])
}
}
\seealso{
Other coercion: \code{\link{as.ala}},
  \code{\link{as.bison}}, \code{\link{as.ecoengine}},
  \code{\link{as.gbif}}, \code{\link{as.idigbio}},
  \code{\link{as.obis}}, \code{\link{as.vertnet}}
}
\concept{coercion}
