% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glsidwpred.R
\name{glsidwpred}
\alias{glsidwpred}
\title{Generate spatial predictions using the hybrid method of generalized
 least squares ('gls')  and inverse distance weighted ('IDW') ('glsidw')}
\usage{
glsidwpred(
  model = var1 ~ 1,
  longlat,
  trainxy,
  y,
  longlatpredx,
  predx,
  corr.args = NULL,
  weights = NULL,
  idp = 2,
  nmaxidw = 12,
  ...
)
}
\arguments{
\item{model}{a formula defining the response variable and predictive variables.}

\item{longlat}{a dataframe contains longitude and latitude of point samples.}

\item{trainxy}{a dataframe contains longitude (long), latitude (lat),
predictive variables and the response variable of point samples. That is,
the location information must be names as 'long' and 'lat'.}

\item{y}{a vector of the response variable in the formula, that is, the left
part of the formula.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point locations
(i.e., the centers of grids) to be predicted. The location information must be
named as 'long' and 'lat'.}

\item{predx}{a dataframe or matrix contains columns of predictive variables
for the grids to be predicted.}

\item{corr.args}{arguments for 'correlation' in 'gls'. See '?corClasses' in 'nlme'
for details. By default, "NULL" is used. When "NULL" is used,
then 'gls' is actually performing 'lm'.}

\item{weights}{describing the within-group heteroscedasticity structure. Defaults
 to "NULL", corresponding to homoscedastic errors. See '?gls' in 'nlme'
for details.}

\item{idp}{a numeric number specifying the inverse distance weighting power.}

\item{nmaxidw}{for a local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is defined in
terms of the space of the spatial locations. By default, 12 observations
are used.}

\item{...}{other arguments passed on to 'gls' and 'gstat'.}
}
\value{
A dataframe of longitude, latitude, and predictions.
}
\description{
This function is for generating spatial predictions using the hybrid
method of 'gls' and 'idw' ('glsidw') (see reference #1).
}
\examples{
\donttest{
library(spm)
library(nlme)

data(petrel)
data(petrel.grid)

gravel <- petrel[, c(1, 2, 6:9, 5)]
longlat <- petrel[, c(1, 2)]
range1 <- 0.8
nugget1 <- 0.5
model <- log(gravel + 1) ~  long + lat +  bathy + dist + I(long^2) + I(lat^2) +
I(lat^3) + I(bathy^2) + I(bathy^3) + I(dist^2) + I(dist^3) + I(relief^2) + I(relief^3)
y <- log(gravel[, 7] +1)

glsidwpred1 <- glsidwpred(model = model, longlat = longlat, trainxy = gravel,
y = y, longlatpredx = petrel.grid[, c(1:2)], predx = petrel.grid,
 idp = 2, nmaxidw = 12, corr.args = corSpher(c(range1, nugget1),
 form = ~ lat + long, nugget = T))

names(glsidwpred1)

# Back transform 'glsidwpred$predictions' to generate the final predictions
glsidw.predictions <- exp(glsidwpred1$predictions) - 1
range(glsidw.predictions)
}

}
\references{
Pinheiro, J. C. and D. M. Bates (2000). Mixed-Effects Models
in S and S-PLUS. New York, Springer.

Pebesma, E.J., 2004. Multivariable geostatistics in S: the gstat package.
Computers & Geosciences, 30: 683-691.
}
\author{
Jin Li
}
