% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsl.r
\docType{data}
\name{splash_user_agent}
\alias{splash_user_agent}
\alias{ua_splashr}
\alias{ua_win10_chrome}
\alias{ua_win10_firefox}
\alias{ua_win10_ie11}
\alias{ua_win7_chrome}
\alias{ua_win7_firefox}
\alias{ua_win7_ie11}
\alias{ua_macos_chrome}
\alias{ua_macos_safari}
\alias{ua_linux_chrome}
\alias{ua_linux_firefox}
\alias{ua_ios_safari}
\title{Overwrite the User-Agent header for all further requests.}
\format{An object of class \code{character} of length 1.}
\usage{
splash_user_agent(splash_obj, user_agent = ua_splashr)

ua_splashr

ua_win10_chrome

ua_win10_firefox

ua_win10_ie11

ua_win7_chrome

ua_win7_firefox

ua_win7_ie11

ua_macos_chrome

ua_macos_safari

ua_linux_chrome

ua_linux_firefox

ua_ios_safari
}
\arguments{
\item{splash_obj}{splashr object}

\item{user_agent}{1 element character vector, defaults to \code{splashr/#.#.#}.}
}
\description{
There are a few built-in user agents, all beginning with \code{ua_}.
}
\examples{
\dontrun{
library(rvest)

URL <- "https://httpbin.org/user-agent"

splash_local \%>\%
  splash_response_body(TRUE) \%>\%
  splash_user_agent(ua_macos_chrome) \%>\%
  splash_go(URL) \%>\%
  splash_html() \%>\%
  html_text("body") \%>\%
  jsonlite::fromJSON()
}
}
\keyword{datasets}
