% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_manual_tour.r
\name{rotate_manip_space}
\alias{rotate_manip_space}
\title{Performs a rotation on the manipulation space of the given manip var.}
\usage{
rotate_manip_space(manip_space, theta, phi)
}
\arguments{
\item{manip_space}{A (p, d+1) dim matrix (manipulation space) to be rotated.}

\item{theta}{Angle (radians) of "in-projection-plane" rotation (ie. on xy-
of the projection). Typically set by the manip_type argument in \code{proj_data()}.}

\item{phi}{Angle (radians) of "out-of-projection-plane" rotation (ie. into
the z-direction of the manipulation space. Effectively changes the norm
of the manip_var in the projection plane.}
}
\value{
A (p, d+1) orthonormal matrix of the rotated (manipulation) space.
The first 2 columns are x and y in the projection plane. The 3rd column
extends "in the z-direction" orthogonal to the projection plane.
}
\description{
A specific R3 rotation of the manipulation space for a 2D tour.
Typically called by \code{manual_tour()}. The first 2 columns are x and y in
the projection plane. The 3rd column extends "in the z-direction" orthogonal
to the projection plane.
}
\examples{
## Setup
dat_std <- scale_sd(wine[, 2:14])
bas <- basis_pca(dat_std)
mv <- manip_var_of(bas)
msp <- create_manip_space(basis = bas, manip_var = mv)

rotate_manip_space(msp, theta = runif(1, max = 2 * pi),
                   phi = runif(1, max = 2 * pi))
}
