% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lawsheCVR.R
\name{lawsheCVR}
\alias{lawsheCVR}
\title{Compute the Lawshe's content validity ratio (CVR)}
\usage{
lawsheCVR(data, max_cat = 4, min_cat = 1, method = "max")
}
\arguments{
\item{data}{a dataframe of categorical value from expert judgment to the item content validity.}

\item{max_cat}{a maximum category point of used rating scale (the default value is 4).}

\item{min_cat}{a minimum category point of used rating scale (the default value is 1).}

\item{method}{a method to determine cutoff value between essential and non-essential items}
}
\value{
a dataframe of CVR of each item as calculated using the Lawshe's formula
}
\description{
Lawshe (1975) proposed an index to quantify content validity of items as
assessed by experts. He coined the index as content validity ratio
(\eqn{CVR}) that can be calculated using the following formula.
\deqn{\displaystyle CVR=\frac{n_e - \frac{N}{2}}{\frac{N}{2}}}
where \eqn{n_e} is the number of experts identifying an item as essential.
In this function, we define a cutoff value using two methods. The first is
"max" calculated by searching the maximum value of the used rating scale
("max_cat") and then divide it by two. The second method is "min" by using
the minimum value of the used rating scale ("min_cat") as the cutoff
criteria.
}
\examples{
# In this example, we define a dataframe describing the rating of ten
# imaginary items as assessed by seven artificial experts. The minimum point
# of the rating scale is 1, and the maximum point that could be given by
# those experts is 4.

df <- data.frame(item1 = c(3,3,3,4,4,4,3),
                 item2 = c(2,4,3,2,4,4,4),
                 item3 = c(4,3,3,2,4,4,3),
                 item4 = c(3,2,3,3,4,3,3),
                 item5 = c(4,4,4,3,3,3,3),
                 item6 = c(3,3,3,4,3,3,4),
                 item7 = c(4,4,4,3,4,4,4),
                 item8 = c(3,3,4,4,4,4,4),
                 item9 = c(4,4,4,3,4,4,4),
                 item10 = c(4,3,4,4,3,3,4))

# Compute the Lawshe's CVR
lawsheCVR(df)
}
\references{
Gilbert, G.E. & Prion, S. Making Sense of Methods and Measurement: Lawshe's Content Validity Index. \emph{Clinical Simulation in Nursing 12}, 530-531 (2016).

Lawshe, C.H. A Quantitative Approach of Content Validity. \emph{Personnel Psychology 28}, 563-575 (1975).
}
