/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerBackgroundComponent;
import bibliothek.gui.dock.displayer.DisplayerDockBorder;
import bibliothek.gui.dock.displayer.DisplayerFocusTraversalPolicy;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.displayer.SingleTabDecider;
import bibliothek.gui.dock.event.SingleTabDeciderListener;
import bibliothek.gui.dock.focus.DockFocusTraversalPolicy;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.themes.basic.MinimalDecorator;
import bibliothek.gui.dock.themes.basic.TabDecorator;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class BasicDockableDisplayer
extends BackgroundPanel
implements DockableDisplayer {
    private Dockable dockable;
    private DockTitle title;
    private DockableDisplayer.Location location;
    private DockStation station;
    private DockController controller;
    private Hints hints = new Hints();
    private boolean respectBorderHint = false;
    private boolean defaultBorderHint = true;
    private boolean singleTabShowInnerBorder = true;
    private boolean singleTabShowOuterBorder = true;
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();
    private Background background = new Background();
    private DisplayerBorder baseBorder;
    private DisplayerBorder contentBorder;
    private SingleTabDeciderListener singleTabListener = new SingleTabDeciderListener(){

        public void showSingleTabChanged(SingleTabDecider source, Dockable dockable) {
            if (dockable == BasicDockableDisplayer.this.dockable) {
                BasicDockableDisplayer.this.updateDecorator();
            }
        }
    };
    private PropertyValue<SingleTabDecider> decider = new PropertyValue<SingleTabDecider>(SingleTabDecider.SINGLE_TAB_DECIDER){

        @Override
        protected void valueChanged(SingleTabDecider oldValue, SingleTabDecider newValue) {
            if (oldValue != null) {
                oldValue.removeSingleTabDeciderListener(BasicDockableDisplayer.this.singleTabListener);
            }
            if (newValue != null) {
                newValue.addSingleTabDeciderListener(BasicDockableDisplayer.this.singleTabListener);
            }
            BasicDockableDisplayer.this.updateDecorator();
        }
    };
    private BasicDockableDisplayerDecorator decorator;
    private boolean singleTabShowing;
    private BackgroundPanel content = new BackgroundPanel(null, false, true){

        public void doLayout() {
            BasicDockableDisplayer.this.doLayout(BasicDockableDisplayer.this.content);
        }

        public Dimension getMinimumSize() {
            return BasicDockableDisplayer.this.getContentMinimumSize();
        }
    };

    public BasicDockableDisplayer(DockStation station) {
        this(station, null, null);
    }

    public BasicDockableDisplayer(DockStation station, Dockable dockable, DockTitle title) {
        this(station, dockable, title, DockableDisplayer.Location.TOP);
    }

    public BasicDockableDisplayer(DockStation station, Dockable dockable, DockTitle title, DockableDisplayer.Location location) {
        super(new GridLayout(1, 1), true, false);
        this.init(station, dockable, title, location);
    }

    protected BasicDockableDisplayer(DockStation station, boolean initialize) {
        super(new GridLayout(1, 1), true, false);
        if (initialize) {
            this.init(station, null, null, DockableDisplayer.Location.TOP);
        }
    }

    protected void init(DockStation station, Dockable dockable, DockTitle title, DockableDisplayer.Location location) {
        this.content.setOpaque(false);
        this.content.setBackground(this.background);
        this.setDecorator(new MinimalDecorator());
        this.setBackground(this.background);
        this.setTitleLocation(location);
        this.setDockable(dockable);
        this.setTitle(title);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new DockFocusTraversalPolicy(new DisplayerFocusTraversalPolicy(this), true));
        this.baseBorder = new DisplayerBorder(this, "basic.base");
        this.contentBorder = new DisplayerBorder(this.content, "basic.content");
    }

    protected void setDecorator(BasicDockableDisplayerDecorator decorator) {
        if (decorator == null) {
            throw new IllegalArgumentException("decorator must not be null");
        }
        if (this.decorator != null) {
            Component oldComponent = this.decorator.getComponent();
            this.remove(oldComponent);
            this.decorator.setDockable(null, null);
            this.decorator.setController(null);
        }
        this.decorator = decorator;
        decorator.setController(this.controller);
        decorator.setDockable(this.content, this.dockable);
        Component newComponent = decorator.getComponent();
        if (newComponent != null) {
            this.add(newComponent);
        }
        this.revalidate();
        this.repaint();
    }

    protected void updateDecorator() {
        if (this.dockable != null && this.station != null) {
            boolean decision = this.decider.getValue().showSingleTab(this.station, this.dockable);
            if (decision != this.singleTabShowing) {
                this.singleTabShowing = decision;
                if (this.singleTabShowing) {
                    this.setDecorator(new TabDecorator(this.station));
                } else {
                    this.setDecorator(new MinimalDecorator());
                }
            }
            this.updateBorder();
        }
    }

    public void setController(DockController controller) {
        Component oldComponent = this.decorator.getComponent();
        this.controller = controller;
        this.decider.setProperties(controller);
        this.decorator.setController(controller);
        this.background.setController(controller);
        this.baseBorder.setController(controller);
        this.contentBorder.setController(controller);
        Component newComponent = this.decorator.getComponent();
        if (oldComponent != newComponent) {
            if (oldComponent != null) {
                this.remove(oldComponent);
            }
            if (newComponent != null) {
                this.add(newComponent);
            }
            this.revalidate();
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public void addDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.add(listener);
    }

    public void removeDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.remove(listener);
    }

    protected DockableDisplayerListener[] listeners() {
        return this.listeners.toArray(new DockableDisplayerListener[this.listeners.size()]);
    }

    public void setStation(DockStation station) {
        this.station = station;
    }

    public DockStation getStation() {
        return this.station;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public void setDockable(Dockable dockable) {
        Component newComponent;
        Component oldComponent = this.decorator.getComponent();
        if (this.dockable != null) {
            this.removeDockable(this.dockable, this.dockable.getComponent());
            this.dockable.configureDisplayerHints(null);
        }
        this.updateDecorator();
        this.decorator.setDockable(this.content, dockable);
        this.hints.setShowBorderHint(null);
        this.dockable = dockable;
        if (dockable != null) {
            this.dockable.configureDisplayerHints(this.hints);
            this.addDockable(dockable, dockable.getComponent());
        }
        if (oldComponent != (newComponent = this.decorator.getComponent())) {
            if (oldComponent != null) {
                this.remove(oldComponent);
            }
            if (newComponent != null) {
                this.add(newComponent);
            }
        }
        this.revalidate();
    }

    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    public void setTitleLocation(DockableDisplayer.Location location) {
        if (location == null) {
            location = DockableDisplayer.Location.TOP;
        }
        this.location = location;
        if (this.title != null) {
            this.title.setOrientation(this.orientation(location));
        }
        this.revalidate();
    }

    protected DockTitle.Orientation orientation(DockableDisplayer.Location location) {
        switch (location) {
            case TOP: {
                return DockTitle.Orientation.NORTH_SIDED;
            }
            case BOTTOM: {
                return DockTitle.Orientation.SOUTH_SIDED;
            }
            case LEFT: {
                return DockTitle.Orientation.WEST_SIDED;
            }
            case RIGHT: {
                return DockTitle.Orientation.EAST_SIDED;
            }
        }
        return null;
    }

    public DockTitle getTitle() {
        return this.title;
    }

    public void setTitle(DockTitle title) {
        if (this.title != null) {
            this.removeTitle(this.title.getComponent());
        }
        this.title = title;
        if (title != null) {
            title.setOrientation(this.orientation(this.location));
            this.addTitle(title.getComponent());
        }
        this.revalidate();
    }

    protected void addDockable(Dockable dockable, Component component) {
        if (component != null) {
            this.content.add(component);
        }
    }

    protected void removeDockable(Dockable dockable, Component component) {
        if (component != null) {
            this.content.remove(component);
        }
    }

    protected Component getComponent(Dockable dockable) {
        return dockable.getComponent();
    }

    public JPanel getContent() {
        return this.content;
    }

    protected void addTitle(Component component) {
        this.content.add(component);
    }

    protected void removeTitle(Component component) {
        this.content.remove(component);
    }

    protected Component getComponent(DockTitle title) {
        return title.getComponent();
    }

    public boolean titleContains(int x, int y) {
        DockTitle title = this.getTitle();
        if (title == null) {
            return false;
        }
        Component component = this.getComponent(title);
        Point point = new Point(x, y);
        point = SwingUtilities.convertPoint(this, point, component);
        point.x -= component.getX();
        point.y -= component.getY();
        return component.contains(point);
    }

    public Component getComponent() {
        return this;
    }

    public Dimension getContentMinimumSize() {
        Dimension titleSize;
        Dimension base;
        if (this.title == null && this.dockable != null) {
            base = this.getComponent(this.dockable).getMinimumSize();
        } else if (this.dockable == null && this.title != null) {
            base = this.getComponent(this.title).getMinimumSize();
        } else if (this.dockable == null && this.title == null) {
            base = new Dimension(0, 0);
        } else if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
            titleSize = this.getComponent(this.title).getMinimumSize();
            base = this.getComponent(this.dockable).getMinimumSize();
            base = new Dimension(base.width + titleSize.width, Math.max(base.height, titleSize.height));
        } else {
            titleSize = this.getComponent(this.title).getMinimumSize();
            base = this.getComponent(this.dockable).getMinimumSize();
            base = new Dimension(Math.max(titleSize.width, base.width), titleSize.height + base.height);
        }
        Insets insets = this.getInsets();
        if (insets != null) {
            base = new Dimension(base.width + insets.left + insets.right, base.height + insets.top + insets.bottom);
        }
        return base;
    }

    protected void doLayout(JPanel content) {
        Insets insets = content.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int x = insets.left;
        int y = insets.top;
        int width = content.getWidth() - insets.left - insets.right;
        int height = content.getHeight() - insets.top - insets.bottom;
        if (this.title == null && this.dockable == null) {
            return;
        }
        width = Math.max(0, width);
        height = Math.max(0, height);
        if (this.title == null) {
            this.getComponent(this.dockable).setBounds(x, y, width, height);
        } else if (this.dockable == null) {
            this.getComponent(this.title).setBounds(x, y, width, height);
        } else {
            Dimension preferred = this.getComponent(this.title).getPreferredSize();
            int preferredWidth = preferred.width;
            int preferredHeight = preferred.height;
            if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
                preferredWidth = Math.min(preferredWidth, width);
                preferredHeight = height;
            } else {
                preferredWidth = width;
                preferredHeight = Math.min(preferredHeight, height);
            }
            if (this.location == DockableDisplayer.Location.LEFT) {
                this.getComponent(this.title).setBounds(x, y, preferredWidth, preferredHeight);
                this.getComponent(this.dockable).setBounds(x + preferredWidth, y, width - preferredWidth, height);
            } else if (this.location == DockableDisplayer.Location.RIGHT) {
                this.getComponent(this.title).setBounds(x + width - preferredWidth, y, preferredWidth, preferredHeight);
                this.getComponent(this.dockable).setBounds(x, y, width - preferredWidth, preferredHeight);
            } else if (this.location == DockableDisplayer.Location.BOTTOM) {
                this.getComponent(this.title).setBounds(x, y + height - preferredHeight, preferredWidth, preferredHeight);
                this.getComponent(this.dockable).setBounds(x, y, preferredWidth, height - preferredHeight);
            } else {
                this.getComponent(this.title).setBounds(x, y, preferredWidth, preferredHeight);
                this.getComponent(this.dockable).setBounds(x, y + preferredHeight, preferredWidth, height - preferredHeight);
            }
        }
    }

    public Insets getDockableInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.title == null && this.dockable == null) {
            return insets;
        }
        if (this.title == null) {
            return insets;
        }
        if (this.dockable != null) {
            Dimension preferred = this.getComponent(this.title).getPreferredSize();
            if (this.location == DockableDisplayer.Location.LEFT) {
                insets.left += preferred.width;
            } else if (this.location == DockableDisplayer.Location.RIGHT) {
                insets.right += preferred.width;
            } else if (this.location == DockableDisplayer.Location.BOTTOM) {
                insets.bottom += preferred.height;
            } else {
                insets.top += preferred.height;
            }
        }
        return insets;
    }

    protected Hints getHints() {
        return this.hints;
    }

    public void setRespectBorderHint(boolean respectBorderHint) {
        if (this.respectBorderHint != respectBorderHint) {
            this.respectBorderHint = respectBorderHint;
            this.updateBorder();
        }
    }

    public boolean isRespectBorderHint() {
        return this.respectBorderHint;
    }

    public void setDefaultBorderHint(boolean defaultBorderHint) {
        if (this.defaultBorderHint != defaultBorderHint) {
            this.defaultBorderHint = defaultBorderHint;
            this.updateBorder();
        }
    }

    public boolean getDefaultBorderHint() {
        return this.defaultBorderHint;
    }

    public void setSingleTabShowInnerBorder(boolean singleTabShowInnerBorder) {
        this.singleTabShowInnerBorder = singleTabShowInnerBorder;
        this.updateBorder();
    }

    public boolean isSingleTabShowInnerBorder() {
        return this.singleTabShowInnerBorder;
    }

    public void setSingleTabShowOuterBorder(boolean singleTabShowOuterBorder) {
        this.singleTabShowOuterBorder = singleTabShowOuterBorder;
        this.updateBorder();
    }

    public boolean isSingleTabShowOuterBorder() {
        return this.singleTabShowOuterBorder;
    }

    public void updateUI() {
        super.updateUI();
        this.updateBorder();
    }

    protected void updateBorder() {
        if (this.singleTabShowing) {
            if (this.singleTabShowInnerBorder) {
                this.setContentBorder(this.getDefaultBorder());
            } else {
                this.setContentBorder(null);
            }
            if (this.singleTabShowOuterBorder) {
                this.setBaseBorder(this.getDefaultBorder());
            } else {
                this.setBaseBorder(null);
            }
        } else {
            this.setContentBorder(null);
            if (this.respectBorderHint) {
                boolean show = this.hints.getShowBorderHint();
                if (show) {
                    this.setBaseBorder(this.getDefaultBorder());
                } else {
                    this.setBaseBorder(null);
                }
            } else if (this.defaultBorderHint) {
                this.setBaseBorder(this.getDefaultBorder());
            } else {
                this.setBaseBorder(null);
            }
        }
    }

    public void setBaseBorder(Border border) {
        if (this.baseBorder != null) {
            this.baseBorder.setBorder(border);
        }
    }

    public void setContentBorder(Border border) {
        if (this.contentBorder != null) {
            this.contentBorder.setBorder(border);
        }
    }

    protected Border getDefaultBorder() {
        return BorderFactory.createBevelBorder(0);
    }

    protected class DisplayerBorder
    extends BorderForwarder
    implements DisplayerDockBorder {
        public DisplayerBorder(JComponent target, String idSuffix) {
            super(DisplayerDockBorder.KIND, "dock.border.displayer." + idSuffix, target);
        }

        public DockableDisplayer getDisplayer() {
            return BasicDockableDisplayer.this;
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements DisplayerBackgroundComponent {
        public Background() {
            super(DisplayerBackgroundComponent.KIND, "dock.background.displayer");
        }

        public Component getComponent() {
            return BasicDockableDisplayer.this;
        }

        public DockableDisplayer getDisplayer() {
            return BasicDockableDisplayer.this;
        }
    }

    protected class Hints
    implements DockableDisplayerHints {
        private Boolean border;

        protected Hints() {
        }

        public void setShowBorderHint(Boolean border) {
            if (this.border != border) {
                this.border = border;
                BasicDockableDisplayer.this.updateBorder();
            }
        }

        public boolean getShowBorderHint() {
            if (this.border != null) {
                return this.border;
            }
            return BasicDockableDisplayer.this.defaultBorderHint;
        }
    }
}

