% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spVariog.R
\name{spVariog}
\alias{spVariog}
\title{Compute empirical residual variogram for CRD or RCBD.}
\usage{
spVariog(geodata, resp = NULL, treat = NULL, block = NULL, coords = NULL,
data = NULL, trend = c("cte", "1st"), scale = FALSE, max.dist,
design = c("crd", "rcbd"), ...)
}
\arguments{
\item{geodata}{an object of class \code{geodata} in which the response variable
should be given in 'data.col', the coordinates in 'coords.col', the treatment vector
should be given as the first column of 'covar.col' and block as the second one.}

\item{resp}{either a vector of response variables or a character giving
the column name where it can be found in 'data'. Optional argument, just required if
geodata is not provided.}

\item{treat}{either a vector of treatment factors or a character giving
the column name where it can be found in 'data'. Optional argument, just required if
geodata is not provided.}

\item{block}{either a vector of block factors or a character giving the column name where
it can be found in 'data'. Optional argument, just required if geodata is not provided.}

\item{coords}{either a 2-column matrix containing the spatial coordinates or a
character vector giving the columns name where the coordinates can be found in 'data'.
Optional argument, just required if geodata is not provided.}

\item{data}{a data frame in which the variables specified as characters will be found.
Optional argument, just required if geodata is not provided.}

\item{trend}{type of spatial trend considered.}

\item{scale}{logical argument. Should the coordinates be scaled? We recommend this
argument to be set as TRUE if your spatial coordinates have high values as in
UTM coordinate system otherwise, you could get errors in the calculations.
See ‘Details’.}

\item{max.dist}{numerical value defining the maximum distance for the variogram.
See \code{\link[geoR]{variog}} documentation for additional information.}

\item{design}{type of experimental design. "crd" corresponds to Completely Randomized
Design and "rcbd" corresponds to Randomized Complete Block Design.}

\item{...}{further arguments to be passed to \code{\link[geoR]{variog}} function.}
}
\value{
An object of class spVariog which is a list with the following components:

\item{vario.res}{an object of class variogram}
\item{data.geo}{an object of class geodata}
\item{des.mat}{the design matrix}
\item{trend}{a character specifying the type of spatial trend}
}
\description{
Compute empirical residual variogram for a Completely Randomized
Design (CRD) or a Randomized Complete Block Design (RCBD) by a call to variog function of the
package geoR.
}
\details{
This function provides a wrapper to variog to compute residual variogram for experimental designs.
The residuals are obtained by

\deqn{\varepsilon = Y-X\beta,}

where Y is the vector of response, X is the design matrix built according to the experimental design
chosen, and \eqn{\beta} is the vector of coefficients estimated by the linear model.

If scale = TRUE the spatial coordinates will be scaled for numerical reasons. The scale is made by
subtracting the minimum spatial coordinate value from all others.
}
\examples{
data("crd_simulated")
dados <- crd_simulated

#Geodata object
geodados <- as.geodata(dados, coords.col = 1:2, data.col = 3,
                            covar.col = 4)
h_max <- summary(geodados)[[3]][[2]]
dist <- 0.6*h_max

# Computing the variogram
variograma <- spVariog(geodata = geodados,
                      trend = "cte", max.dist = dist, design = "crd",
                      scale = FALSE)

plot(variograma, ylab = "Semivariance", xlab = "Distance")

}
\seealso{
\code{\link[geoR]{variog}}
}
