\name{example}
\alias{example}
\docType{data}
\title{
Broad sense heritability calculation.
}
\description{
This dataset contains phenotpic data for 41 potato lines evaluated in 3 environments in an RCBD design. The phenotypic trait is tuber quality and we show how to obtain an estimate of example for the trait.

}
\usage{data("example")}
\format{
  The format is:
 chr "example"
}
\source{
This data was generated by a potato study.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{
####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples
####=========================================####
data(example)
head(example)
####=========================================####
#### fit the mixed model and extract var.comp
####=========================================####
#ans1 <- mmer2(y~1, random=~Name + Env + Name:Env + Block,data=example, method="NR")
#vc <- ans1$var.comp
#V_E <- vc[2,1];V_GE <- vc[3,1];V_G <- vc[1,1];Ve <- vc[5,1]
####=========================================####
#### calculate heritability
####=========================================####
#n.env <- length(levels(example$Env))
#h2c <- V_G/(V_G + V_GE/n.env + Ve/(2*n.env)) #the 2 is a reference for block#
#h2c

####=========================================####
####=========================================####
#### using the 'mmer' function would be fitted as
####=========================================####
####=========================================####
#data(example)
#Y <- example$y
#Z1 <- model.matrix(~Name-1,data=example)
#Z2 <- model.matrix(~Env-1,data=example)
#Z3 <- model.matrix(~Name:Env-1,data=example)
#Z4 <- model.matrix(~Block-1,data=example)
#ETA <- list(Name=list(Z=Z1),
#            Env=list(Z=Z2),
#            Name.Env=list(Z=Z3),
#            Block=list(Z=Z4))

#ans1 <- mmer(Y=Y,Z=ETA)
#vc <- ans1$var.comp

}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{mmer}} and \code{\link{mmer2}}}
