% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpts_plot.R
\name{bpts_plot}
\alias{bpts_plot}
\title{Boundary Points Plot}
\usage{
bpts_plot(
  bpts,
  xlab = "x",
  ylab = "y",
  export_name = "bpts plot.png",
  save_plot = FALSE,
  colour = TRUE,
  legend.position = "right"
)
}
\arguments{
\item{bpts}{your bpts object created by the extract_bpts() function.}

\item{xlab}{the x-axis label. Defaults to "".}

\item{ylab}{the y-axis label. Defaults to "".}

\item{export_name}{the filename of your plot if you choose to export it. Include .png suffix. Defaults to "bpts plot.png" if save_plot = TRUE.}

\item{save_plot}{TRUE or FALSE to save the plot. Defaults to FALSE.}

\item{colour}{TRUE or FALSE to plot using colour or in black and white. Defaults to TRUE.}

\item{legend.position}{Define the position of the ggplot legend, as per ggplot capability. Default to "right".}
}
\value{
a ggplot2 scatterplot
}
\description{
bpts_plot creates a ggplot2 scatterplot of your bpts object with the boundary
lines and no-data zones identified.
}
\examples{
a = rnorm(100,0,1)
b = rnorm(100,0,1)
bptsExample = extract_bpts(a,b)
bpts_plot(bptsExample, "a", "b")
}
