% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Grid}
\alias{Grid}
\title{Create a new \code{Grid} object}
\usage{
Grid(levels, nlevels = NULL, dimNames = NULL, index = NULL)
}
\arguments{
\item{levels}{A list with the levels of the variables. The length
of the list gives the spatial dimension. The \eqn{i}-th element
must be a numeric vector containing the distinct values of the
corresponding variable.}

\item{nlevels}{Integer vector giving the number of levels by
dimension. This formal argument is used only when \code{levels} is
missing. In this case, the nodes for dimension \eqn{i} will be
regularly spaced between \code{0.0} and \code{1.0}.}

\item{dimNames}{If the list \code{levels} does not have names,
then the character vector \code{dimNames} will be used.}

\item{index}{An array with integer values and dimension
corresponding to the spatial dimensions. Each value represent the
number of the corresponding node in a "flat" representation
(data.frame or matrix), and will be used in tasks such as
interpolation.}
}
\value{
An object with S4 class \code{"Grid"}. If needed, this
object can be coerced to a data frame or to a matrix by using the
methods \code{as.data.frame} or \code{as.matrix}.
}
\description{
Create a Grid object.
}
\note{
If \code{index} is not provided, the vectors in the
\code{levels} list can be unsorted, and they will be
sorted. However, when a non-default \code{index} is provided, the
levels must be sorted. This rule is intended to reduce the risk of
error.
}
\examples{
myGD1 <- Grid(levels = list("X" = c(0, 1), "Y" = c(0.0, 0.5, 1.0)))
## the same with less effort
myGD2 <- Grid(nlevels = c("X" = 2, "Y" = 3))
nlevels(myGD2)
levels(myGD2)
}
\author{
Yves Deville
}

