% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm2.R
\name{sm2_encrypt_hex}
\alias{sm2_encrypt_hex}
\alias{sm2_decrypt_hex}
\alias{sm2_encrypt_base64}
\alias{sm2_decrypt_base64}
\title{SM2 Encrypt/Decrypt - hex and base64}
\usage{
sm2_encrypt_hex(data, public_key)

sm2_decrypt_hex(data, private_key)

sm2_encrypt_base64(data, public_key)

sm2_decrypt_base64(data, private_key)
}
\arguments{
\item{data}{for encrypt, data is a raw vector, for decrypt, data is a hex or base64 string}

\item{public_key}{a public key represented as a hexadecimal string}

\item{private_key}{a private key represented as a hexadecimal string}
}
\value{
\describe{
  \item{\link{sm2_encrypt_hex}}{returns a hex string of the cipher text}
  \item{\link{sm2_decrypt_hex}}{returns a raw vector of the plain text}
  \item{\link{sm2_encrypt_base64}}{returns a base64 string of the cipher text}
  \item{\link{sm2_decrypt_base64}}{returns a raw vector of the plain text}
}
}
\description{
For ease of use, we have provided functions to encrypt data into hex or
base64 format and decrypt them from these formats.
}
\examples{
## encrypt and decrypt from hex string
keypair <- sm2_gen_keypair()
private_key <- keypair$private_key
public_key <- keypair$public_key
data <- 'abc' |> charToRaw()
enc <- sm2_encrypt_hex(data, public_key)
enc
dec <- sm2_decrypt_hex(enc, private_key)
dec
enc <- sm2_encrypt_base64(data, public_key)
enc
dec <- sm2_decrypt_base64(enc, private_key)
dec
}
