% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm.R
\docType{package}
\name{slm-package}
\alias{slm-package}
\title{slm: A package for stationary linear models}
\description{
The \code{slm} package enables to fit linear models on datasets considering the dependence between the observations.
 Most of the functions are based on the functions and methods of \code{lm}, with the same arguments and the same format for the outputs.
}
\section{\code{slm} function, in "slm-main.R"}{

 The \code{slm} function is the main function of this package. Its architecture is the same as the \code{lm} function
 but it takes into account the possible correlation between the observations. To estimate the asymptotic covariance matrix of
 the least squares estimator, several approaches are available: "fitAR" calls the
 \code{cov_AR} function, "spectralproj" the \code{cov_spectralproj} function, "kernel" the \code{cov_kernel} function,
 "efromovich" the \code{cov_efromovich} function and "select" the \code{cov_select} function.
}

\section{Methods for \code{slm}, in "slm-method.R"}{

 The \code{slm} function has several associated methods, which are the same as for the \code{lm} function.
 The available methods are: \code{summary}, \code{confint}, \code{predict} and \code{plot}.
}

\section{Others functions, in "auxiliary-fun.R"}{

 The package has some auxiliary functions, in particular some predefined kernels for the kernel method of \code{slm} function: the
 trapeze kernel, the triangle kernel and the rectangular kernel. The user can also define his own kernel and put it in the argument
 \code{kernel_fonc} in the \code{slm} function.
}

\section{Generative functions, in "generative.R"}{

 The \code{generative_process} function generates some stationary processes.
 The \code{generative_model} function generates some designs.
}

\section{Data}{

 The package contains a dataset "shan". This dataset comes from a study about fine particle pollution in the city of Shanghai. The data are available on the
 following website \url{https://archive.ics.uci.edu/ml/datasets/PM2.5+Data+of+Five+Chinese+Cities#}.
}

\references{
E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
