% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carapeto_holt.R
\name{carapeto_holt}
\alias{carapeto_holt}
\title{Carapeto-Holt Test for Heteroskedasticity in a Linear Regression Model}
\usage{
carapeto_holt(
  mainlm,
  deflator = NA,
  prop_central = 1/3,
  group1prop = 1/2,
  qfmethod = "imhof",
  alternative = c("greater", "less", "two.sided"),
  twosidedmethod = c("doubled", "kulinskaya"),
  statonly = FALSE
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{deflator}{Either a character specifying a column name from the
design matrix of \code{mainlm} or an integer giving the index of a
column of the design matrix. This variable is suspected to be
related to the error variance under the alternative hypothesis.
\code{deflator} may not correspond to a column of 1's (intercept).
Default \code{NA} means the data will be left in its current order
(e.g. in case the existing index is believed to be associated with
error variance).}

\item{prop_central}{A double specifying the proportion of central
observations to exclude when comparing the two subsets of observations.
\code{\link[base]{round}} is used to ensure the number of central
observations is an integer. Defaults to \eqn{\frac{1}{3}}.}

\item{group1prop}{A double specifying the proportion of remaining
observations \emph{(after excluding central observations)} to allocate
to the first group. The default value of \code{1 / 2} means that an
equal number of observations is assigned to the first and second groups.}

\item{qfmethod}{A character, either \code{"imhof"}, \code{"davies"}, or
\code{"integrate"}, corresponding to the \code{algorithm} argument
of \code{\link[skedastic]{pRQF}}. The default is \code{"imhof"}.}

\item{alternative}{A character specifying the form of alternative
hypothesis. If it is suspected that the error variance is positively
associated with the deflator variable, \code{"greater"}. If it is
suspected that the error variance is negatively associated with deflator
variable, \code{"less"}. If no information is available on the suspected
direction of the association, \code{"two.sided"}. Defaults to
\code{"greater"}.}

\item{twosidedmethod}{A character indicating the method to be used to compute
two-sided \eqn{p}-values for the parametric test when \code{alternative}
is \code{"two.sided"}. The argument is passed to
\code{\link{twosidedpval}} as its \code{method} argument.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the two methods (parametric and nonparametric) of
   \insertCite{Carapeto03;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
The test is based on the methodology of
   \insertCite{Goldfeld65;textual}{skedastic} but does not require any
   auxiliary regression. It entails ordering the observations by some
   suspected deflator (one of the explanatory variables) in such a way
   that, under the alternative hypothesis, the observations would now
   be arranged in decreasing order of error variance. A specified proportion
   of the most central observations (under this ordering) is removed,
   leaving a subset of lower observations and a subset of upper
   observations. The test statistic is then computed as a ratio of quadratic
   forms corresponding to the sums of squared residuals of the upper and
   lower observations respectively. \eqn{p}-values are computed by the
   Imhof algorithm in \code{\link{pRQF}}.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
carapeto_holt(mtcars_lm, deflator = "qsec", prop_central = 0.25)
# Same as previous example
mtcars_list <- list("y" = mtcars$mpg, "X" = cbind(1, mtcars$wt, mtcars$qsec, mtcars$am))
carapeto_holt(mtcars_list, deflator = 3, prop_central = 0.25)

}
\references{
{\insertAllCited{}}
}
