% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize_lme.R
\name{se_ybar}
\alias{se_ybar}
\title{Standard error of sample mean for mixed models}
\usage{
se_ybar(fit)
}
\arguments{
\item{fit}{Fitted mixed effects model (\code{\link[lme4]{merMod}}-class).}
}
\value{
The standard error of the sample mean of \code{fit}.
}
\description{
Compute the standard error for the sample mean for mixed models,
               regarding the extent to which clustering affects the standard errors.
               May be used as part of the multilevel power calculation for cluster sampling
               (see \cite{Gelman and Hill 2007, 447ff}).
}
\examples{
library(lme4)
fit <- lmer(Reaction ~ 1 + (1 | Subject), sleepstudy)
se_ybar(fit)

}
\references{
Gelman A, Hill J. 2007. Data analysis using regression and multilevel/hierarchical models. Cambridge, New York: Cambridge University Press
}
