% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.class_vector_cube}
\alias{plot.class_vector_cube}
\title{Plot Segments}
\usage{
\method{plot}{class_vector_cube}(
  x,
  ...,
  tile = x[["tile"]][[1]],
  legend = NULL,
  seg_color = "black",
  line_width = 0.5,
  palette = "Spectral",
  scale = 1
)
}
\arguments{
\item{x}{Object of class "segments".}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tile to be plotted.}

\item{legend}{Named vector that associates labels to colors.}

\item{seg_color}{Segment color.}

\item{line_width}{Segment line width.}

\item{palette}{Alternative RColorBrewer palette}

\item{scale}{Scale to plot map (0.4 to 1.0)}
}
\value{
A plot object with an RGB image
                      or a B/W image on a color
                      scale using the chosen palette
}
\description{
Plot vector classified cube
}
\note{
To see which color palettes are supported, please run
}
\examples{
if (sits_run_examples()) {
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # segment the image
    segments <- sits_segment(
        cube = cube,
        output_dir = tempdir()
    )
    # create a classification model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # classify the segments
    probs_segs <- sits_classify(
        data = segments,
        ml_model = rfor_model,
        output_dir = tempdir()
    )
    #
    # Create a classified vector cube
    class_segs <- sits_label_classification(
        cube = probs_segs,
        output_dir = tempdir(),
        multicores = 2,
        memsize = 4
    )
    # plot the segments
    plot(class_segs)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
