% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfpower.R
\name{dfpower}
\alias{dfpower}
\title{Tabulate BIC of SITAR models by degrees of freedom and xy power transformations}
\usage{
dfpower(
  model,
  df,
  xpowers,
  ypowers,
  FUN = BICadj,
  maxIter = nlmeControl()$maxIter,
  verbose = FALSE
)
}
\arguments{
\item{model}{fitted \pkg{sitar} model to be updated.}

\item{df}{vector of degrees of freedom to be fitted (defaults to df in \code{model}).}

\item{xpowers}{vector of powers to apply to x (defaults to x power in \code{model}).}

\item{ypowers}{vector of powers to apply to y (defaults to y power in \code{model}).}

\item{FUN}{function to be tabulated (default BICadj, or e.g. AICadj or varexp).}

\item{maxIter}{maximum number of iterations per fit.}

\item{verbose}{logical controlling monitoring.}
}
\value{
Table or vector of returned values.
}
\description{
\code{dfpower} fits a series of SITAR models tabulated by specified degrees of freedom
and power transformations of x and y, returning a table of function values (e.g. BIC)
applied to each model.
}
\details{
The function provides a convenient way to optimise the model's degrees of freedom
and explore transformations of x and y, based by default on adjusted BIC.
The function value is returned with changed sign if there is a warning, or as
NA if there is an error. The run-time can be shortened by reducing \code{maxIter},
as the models that converge do so in relatively few iterations, and much of
the run-time is spent on models that fail to converge.

\code{FUN} can be any function returning a single numerical value.

The returned table can be rearranged using \code{\link{aperm}}.
}
\examples{
data(heights)
m1 <- sitar(log(age), height, id, heights, 4)
dfpower(m1, df=4:5, xpowers=0:1, maxIter=4)
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
