% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DifferenceDistribution.R
\name{Bernoulli_diff_dist}
\alias{Bernoulli_diff_dist}
\title{Compute the distribution of differences of replacement samples of two Bernoulli experiments.}
\usage{
Bernoulli_diff_dist(kA, nA, kB, nB, test_rate)
}
\arguments{
\item{kA}{number of A successes observed.}

\item{nA}{number of A experiments.}

\item{kB}{number of B successes observed.}

\item{nB}{number of B experiments.}

\item{test_rate}{numeric, difference in rate of A-B to test.  Note: it is best to specify this prior to looking at the data.}
}
\value{
Bernoulli difference test statistic.
}
\description{
Compute the distribution of \code{max(1, nBeffective/nAeffective)*sum(a) - max(1, nAeffective/nBeffective)*sum(b)}
where \code{a} is a 0/1 vector of length \code{nAeffective} with each item 1 with independent probability \code{(kA+kB)/(nA+nB)},
and \code{b} is a 0/1 vector of length \code{nBeffective} with each item 1 with independent probability \code{(kA+kB)/(nA+nB)}.
The idea is: under this scaling differences in success rates between the two processes are easily observed as differences
in counts returned by the scaled processes.
The method be used to get the exact probability of a given difference under the null hypothesis that
both the A and B processes have the same success rate.
}
\details{
Note the intent that we are measuring the results of an A/B test with \code{nA \%\% nB == 0}
(no padding needed),  or  \code{nA >> nB}, or \code{nB >> nA}. The larger sample is padded so
the smaller sample divides evenly into it (allowing faster calculation methods).  The sizes of the
effective samples are given by \code{nAeffective} and \code{nBeffective}.  The padding will
slightly over-estimate confidences due the increased sample size, but if \code{nA} and \code{nB} are
not near each other- this will be a small effect.  However, padding does represent a downward
bias on significance estimates.
}
\examples{

Bernoulli_diff_dist(2000, 5000, 100, 200, 0.1)
Bernoulli_diff_dist(2000, 5000, 100, 200)
Bernoulli_diff_dist(100, 200, 2000, 5000, 0.1)

# let sigr extend the A experiment to estimate
# biased down
kA <- 2000
nA <- 5000
kB <- 100
nB <- 199
Bernoulli_diff_dist(kA, nA, kB, nB)
# user truncating the A experiment
# biased up (modulo rounding issues)
nAEffective <- floor(nA/nB)*nB
kAEffectiveF <- floor((kA/nA)*nAEffective)
Bernoulli_diff_dist(kAEffectiveF, nAEffective, kB, nB)
kAEffectiveC <- ceiling((kA/nA)*nAEffective)
Bernoulli_diff_dist(kAEffectiveC, nAEffective, kB, nB)

}
