% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assets.R
\name{assets_download}
\alias{assets_download}
\alias{assets_ensure}
\alias{assets_cleanup}
\alias{assets_remove}
\alias{assets_info}
\alias{assets_version}
\title{Manage shinylive assets}
\usage{
assets_download(
  version = assets_version(),
  ...,
  dir = assets_cache_dir(),
  url = assets_bundle_url(version)
)

assets_ensure(
  version = assets_version(),
  ...,
  dir = assets_cache_dir(),
  url = assets_bundle_url(version)
)

assets_cleanup(..., dir = assets_cache_dir())

assets_remove(versions, ..., dir = assets_cache_dir())

assets_info()

assets_version()
}
\arguments{
\item{version}{The version of the assets to download.}

\item{...}{Ignored.}

\item{dir}{The asset cache directory. Unless testing, the default behavior
should be used.}

\item{url}{The URL to download the assets from. Unless testing, the default
behavior should be used.}

\item{versions}{The assets versions to remove.}
}
\value{
\code{assets_version()} returns the version of the currently supported Shinylive.

All other methods return \code{invisible()}.
}
\description{
Helper methods for managing shinylive assets.
}
\section{Functions}{
\itemize{
\item \code{assets_download()}: Downloads the shinylive assets bundle from GitHub and
extracts it to the specified directory. The bundle will always be
downloaded from GitHub, even if it already exists in the cache directory
(\verb{dir=}).

\item \code{assets_ensure()}: Ensures a local copy of shinylive is installed. If a local
copy of shinylive is not installed, it will be downloaded and installed.
If a local copy of shinylive is installed, its path will be returned.

\item \code{assets_cleanup()}: Removes local copies of shinylive web assets, except for
the one used by the current version of \pkg{shinylive}.

\item \code{assets_remove()}: Removes a local copies of shinylive web assets.

\item \code{assets_info()}: Prints information about the local shinylive
assets that have been installed.

\item \code{assets_version()}: Returns the version of the currently supported Shinylive
assets version.

}}
