% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinylight.R
\name{sendProgress}
\alias{sendProgress}
\title{Sends a progress update to the client.}
\usage{
sendProgress(numerator, denominator = 1)
}
\arguments{
\item{numerator}{The progress, out of \code{denominator}}

\item{denominator}{What the progress is out of. You could use this for the
number of known items to be completed so that each call increases either
the numerator (for more items done) and/or the denominator (for more items
discovered that need to be done). However, it is not necessary to be so
precise; you can set the numerator and denominator however you like on
each call as long as it makes sense to the user.}
}
\value{
No return value
}
\description{
During a slow remote procedure call, call this to inform the client
of progress.
}
\examples{
server <- slServer(
  port = 50051,
  interface = list(long_and_complicated = function(x) {
    sendProgress(0,3)
    # First part of work that takes some time
    # ...
    sendProgress(1,3)
    # Second part of work that takes some time
    # ...
    sendProgress(2,3)
    # Last part of work that takes some time
    # ...
    sendProgress(3,3)
  })
)
# ...
slStop(server)
}
\seealso{
\code{\link{sendInfoText}} for sending text to the user.
}
