% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtual-select.R
\name{virtualSelectInput}
\alias{virtualSelectInput}
\title{Virtual Select Input}
\usage{
virtualSelectInput(
  inputId,
  label,
  choices,
  selected = NULL,
  multiple = FALSE,
  search = FALSE,
  hideClearButton = !multiple,
  autoSelectFirstOption = !multiple,
  showSelectedOptionsFirst = FALSE,
  showValueAsTags = FALSE,
  optionsCount = 10,
  noOfDisplayValues = 50,
  allowNewOption = FALSE,
  disableSelectAll = !multiple,
  disableOptionGroupCheckbox = !multiple,
  disabled = FALSE,
  ...,
  stateInput = TRUE,
  html = FALSE,
  inline = FALSE,
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{List of values to select from.
You can use:
\itemize{
\item \code{vector} use a simple vector for better performance.
\item \verb{named list} / \verb{named vector} in the same way as with \code{\link[shiny:selectInput]{shiny::selectInput()}}
\item custom formatted \code{list} allowing to use more options, must correspond to \href{https://sa-si-dev.github.io/virtual-select/#/properties}{virtual-select specifications}
\item output of \code{\link[=prepare_choices]{prepare_choices()}}
}}

\item{selected}{The initially selected value (or multiple values if \code{multiple = TRUE}). If not specified then defaults to the first value for
single-select lists and no values for multiple select lists.}

\item{multiple}{Is selection of multiple items allowed?}

\item{search}{Enable search feature.}

\item{hideClearButton}{Hide clear value button.}

\item{autoSelectFirstOption}{Select first option by default on load.}

\item{showSelectedOptionsFirst}{Show selected options at the top of the dropbox.}

\item{showValueAsTags}{Show each selected values as tags with remove icon.}

\item{optionsCount}{No.of options to show on viewport.}

\item{noOfDisplayValues}{Maximum no.of values to show in the tooltip for multi-select.}

\item{allowNewOption}{Allow to add new option by searching.}

\item{disableSelectAll}{Disable select all feature of multiple select.}

\item{disableOptionGroupCheckbox}{Disable option group title checkbox.}

\item{disabled}{Disable entire dropdown.}

\item{...}{Other arguments passed to JavaScript method, see
\href{https://sa-si-dev.github.io/virtual-select/#/properties}{virtual-select documentation} for a full list of options.}

\item{stateInput}{Activate or deactivate the input to know if the menu is opened or not, see details.}

\item{html}{Allow usage of HTML in choices.}

\item{inline}{Display inline with label or not.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}
}
\value{
A \code{shiny.tag} object that can be used in a UI definition.
}
\description{
A select dropdown widget made for performance,
based on \href{https://github.com/sa-si-dev/virtual-select}{virtual-select} JavaScript library.
}
\note{
State of the menu (open or close) is accessible server-side through the input value:
\verb{input$<inputId>_open}, which can be \code{TRUE} (opened) or \code{FALSE} (closed) or \code{NULL} (when initialized).
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("Virtual Select"),

  fluidRow(
    column(
      width = 4,
      virtualSelectInput(
        inputId = "single",
        label = "Single select :",
        choices = month.name,
        search = TRUE
      ),
      virtualSelectInput(
        inputId = "multiple",
        label = "Multiple select:",
        choices = setNames(month.abb, month.name),
        multiple = TRUE
      )
    ),
    column(
      width = 4,
      tags$b("Single select :"),
      verbatimTextOutput("res_single"),
      tags$b("Is virtual select open ?"),
      verbatimTextOutput(outputId = "res_single_open"),

      tags$br(),

      tags$b("Multiple select :"),
      verbatimTextOutput("res_multiple"),
      tags$b("Is virtual select open ?"),
      verbatimTextOutput(outputId = "res_multiple_open")
    )
  )


)

server <- function(input, output, session) {

  output$res_single <- renderPrint(input$single)
  output$res_single_open <- renderPrint(input$single_open)

  output$res_multiple <- renderPrint(input$multiple)
  output$res_multiple_open <- renderPrint(input$multiple_open)

}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
\itemize{
\item \code{\link[=demoVirtualSelect]{demoVirtualSelect()}} for demo apps
\item \code{\link[=updateVirtualSelect]{updateVirtualSelect()}} for updating from server
}
}
