% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-spectrum.R
\name{spectrumInput}
\alias{spectrumInput}
\title{Palette Color Picker with Spectrum Library}
\usage{
spectrumInput(
  inputId,
  label,
  choices = NULL,
  selected = NULL,
  flat = FALSE,
  options = list(),
  update_on = c("move", "dragstop", "change"),
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{List of colors to display in the menu.}

\item{selected}{The initially selected value.}

\item{flat}{Display the menu inline.}

\item{options}{Additional options to pass to spectrum,
possible values are described here : \url{https://bgrins.github.io/spectrum/#options}.}

\item{update_on}{When to update value server-side: \code{"move"} (default, each time a new color is selected),
\code{"dragstop"} (when use user stop dragging cursor), \code{"change"} (when the input is closed).}

\item{width}{The width of the input, e.g. \code{400px}, or \code{100\%}.}
}
\value{
The selected color in Hex format server-side
}
\description{
A widget to select a color within palettes, and with more options if needed.
}
\examples{
if (interactive()) {

library("shiny")
library("shinyWidgets")
library("scales")

ui <- fluidPage(
  tags$h1("Spectrum color picker"),

  br(),

  spectrumInput(
    inputId = "myColor",
    label = "Pick a color:",
    choices = list(
      list('black', 'white', 'blanchedalmond', 'steelblue', 'forestgreen'),
      as.list(brewer_pal(palette = "Blues")(9)),
      as.list(brewer_pal(palette = "Greens")(9)),
      as.list(brewer_pal(palette = "Spectral")(11)),
      as.list(brewer_pal(palette = "Dark2")(8))
    ),
    options = list(`toggle-palette-more-text` = "Show more")
  ),
  verbatimTextOutput(outputId = "res")

)

server <- function(input, output, session) {

  output$res <- renderPrint(input$myColor)

}

shinyApp(ui, server)

}
}
