% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{useSweetAlert}
\alias{useSweetAlert}
\title{Load Sweet Alert dependencies}
\usage{
useSweetAlert(
  theme = c("sweetalert2", "minimal", "dark", "bootstrap-4", "borderless")
)
}
\arguments{
\item{theme}{Theme to modify alerts appearance.}
}
\description{
This function isn't necessary for \code{sendSweetAlert}, \code{confirmSweetAlert},
 \code{inputSweetAlert} (except if you want to use a theme other than the default one),
 but is still needed for \code{progressSweetAlert}.
}
\examples{
if (interactive()) {

  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(

    useSweetAlert("borderless"),

    tags$h2("Sweet Alert examples"),
    actionButton(
      inputId = "success",
      label = "Launch a success sweet alert",
      icon = icon("check")
    ),
    actionButton(
      inputId = "error",
      label = "Launch an error sweet alert",
      icon = icon("remove")
    ),
    actionButton(
      inputId = "sw_html",
      label = "Sweet alert with HTML",
      icon = icon("thumbs-up")
    )
  )

  server <- function(input, output, session) {

    observeEvent(input$success, {
      sendSweetAlert(
        session = session,
        title = "Success !!",
        text = "All in order",
        type = "success"
      )
    })

    observeEvent(input$error, {
      sendSweetAlert(
        session = session,
        title = "Error !!",
        text = "It's broken...",
        type = "error"
      )
    })

    observeEvent(input$sw_html, {
      sendSweetAlert(
        session = session,
        title = NULL,
        text = tags$span(
          tags$h3("With HTML tags",
                  style = "color: steelblue;"),
          "In", tags$b("bold"), "and", tags$em("italic"),
          tags$br(),
          "and",
          tags$br(),
          "line",
          tags$br(),
          "breaks",
          tags$br(),
          "and an icon", icon("thumbs-up")
        ),
        html = TRUE
      )
    })

  }

  shinyApp(ui, server)
}
}
\seealso{
\code{\link{sendSweetAlert}}, \code{\link{confirmSweetAlert}}, \code{\link{inputSweetAlert}}.
}
