% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-pretty.R
\name{prettyCheckbox}
\alias{prettyCheckbox}
\title{Pretty Checkbox Input}
\usage{
prettyCheckbox(inputId, label, value = FALSE, status = "default",
  shape = c("square", "curve", "round"), outline = FALSE,
  fill = FALSE, thick = FALSE, animation = NULL, icon = NULL,
  plain = FALSE, bigger = FALSE, inline = FALSE, width = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control.}

\item{value}{Initial value (\code{TRUE} or \code{FALSE}).}

\item{status}{Add a class to the checkbox,
you can use Bootstrap status like 'info', 'primary', 'danger', 'warning' or 'success'.}

\item{shape}{Shape of the checkbox between \code{square}, \code{curve} and \code{round}.}

\item{outline}{Color also the border of the checkbox (\code{TRUE} or \code{FALSE}).}

\item{fill}{Fill the checkbox with color (\code{TRUE} or \code{FALSE}).}

\item{thick}{Make the content inside checkbox smaller (\code{TRUE} or \code{FALSE}).}

\item{animation}{Add an animation when checkbox is checked, a value between
\code{smooth}, \code{jelly}, \code{tada}, \code{rotate}, \code{pulse}.}

\item{icon}{Optional, display an icon on the checkbox, must be an icon created with \code{icon}.}

\item{plain}{Remove the border when checkbox is checked (\code{TRUE} or \code{FALSE}).}

\item{bigger}{Scale the checkboxes a bit bigger (\code{TRUE} or \code{FALSE}).}

\item{inline}{Display the input inline, if you want to place checkboxes next to each other.}

\item{width}{The width of the input, e.g. \code{400px}, or \code{100\%}.}
}
\value{
\code{TRUE} or \code{FALSE} server-side.
}
\description{
Create a pretty checkbox that can be used to specify logical values.
}
\note{
Due to the nature of different checkbox design, certain animations are not applicable in some arguments combinations.
You can find examples on the pretty-checkbox official page : \url{https://lokesh-coder.github.io/pretty-checkbox/}.
}
\examples{
\dontrun{

if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h1("Pretty checkbox"),
  br(),

  fluidRow(
    column(
      width = 4,
      prettyCheckbox(inputId = "checkbox1",
                   label = "Click me!"),
      verbatimTextOutput(outputId = "res1"),
      br(),
      prettyCheckbox(inputId = "checkbox4",  label = "Click me!",
                     outline = TRUE,
                   plain = TRUE, icon = icon("thumbs-up")),
      verbatimTextOutput(outputId = "res4")
    ),
    column(
      width = 4,
      prettyCheckbox(inputId = "checkbox2",
                     label = "Click me!", thick = TRUE,
                     animation = "pulse", status = "info"),
      verbatimTextOutput(outputId = "res2"),
      br(),
      prettyCheckbox(inputId = "checkbox5",
                     label = "Click me!", icon = icon("check"),
                     animation = "tada", status = "default"),
      verbatimTextOutput(outputId = "res5")
    ),
    column(
      width = 4,
      prettyCheckbox(inputId = "checkbox3",  label = "Click me!",
                     shape = "round", status = "danger",
                   fill = TRUE, value = TRUE),
      verbatimTextOutput(outputId = "res3")
    )
  )

)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$checkbox1)
  output$res2 <- renderPrint(input$checkbox2)
  output$res3 <- renderPrint(input$checkbox3)
  output$res4 <- renderPrint(input$checkbox4)
  output$res5 <- renderPrint(input$checkbox5)

}

shinyApp(ui, server)



# Inline example ----

ui <- fluidPage(
  tags$h1("Pretty checkbox: inline example"),
  br(),
  prettyCheckbox(inputId = "checkbox1",
                 label = "Click me!",
                 status = "success",
                 outline = TRUE,
                 inline = TRUE),
  prettyCheckbox(inputId = "checkbox2",
                 label = "Click me!",
                 thick = TRUE,
                 shape = "curve",
                 animation = "pulse",
                 status = "info",
                 inline = TRUE),
  prettyCheckbox(inputId = "checkbox3",
                 label = "Click me!",
                 shape = "round",
                 status = "danger",
                 value = TRUE,
                 inline = TRUE),
  prettyCheckbox(inputId = "checkbox4",
                 label = "Click me!",
                 outline = TRUE,
                 plain = TRUE,
                 animation = "rotate",
                 icon = icon("thumbs-up"),
                 inline = TRUE),
  prettyCheckbox(inputId = "checkbox5",
                 label = "Click me!",
                 icon = icon("check"),
                 animation = "tada",
                 status = "primary",
                 inline = TRUE),
  verbatimTextOutput(outputId = "res")
)

server <- function(input, output, session) {

  output$res <- renderPrint(c(input$checkbox1,
                              input$checkbox2,
                              input$checkbox3,
                              input$checkbox4,
                              input$checkbox5))

}

shinyApp(ui, server)

}

}
}
\seealso{
See \code{\link{updatePrettyCheckbox}} to update the value server-side. See \code{\link{prettySwitch}} and
\code{\link{prettyToggle}} for similar widgets.
}
