% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-dropdown.R
\name{dropdownButton}
\alias{dropdownButton}
\title{Dropdown Button}
\usage{
dropdownButton(..., circle = TRUE, status = "default",
  size = "default", icon = NULL, label = NULL, tooltip = FALSE,
  right = FALSE, up = FALSE, width = NULL, margin = "10px",
  inputId = NULL)
}
\arguments{
\item{...}{List of tag to be displayed into the dropdown menu.}

\item{circle}{Logical. Use a circle button}

\item{status}{Add a class to the buttons, you can use Bootstrap status like 'info', 'primary', 'danger', 'warning' or 'success'.
Or use an arbitrary strings to add a custom class, e.g. : with \code{status = 'myClass'}, buttons will have class \code{btn-myClass}.}

\item{size}{Size of the button : default, lg, sm, xs.}

\item{icon}{An icon to appear on the button.}

\item{label}{Label to appear on the button. If circle = TRUE and tooltip = TRUE, label is used in tooltip.}

\item{tooltip}{Put a tooltip on the button, you can customize tooltip with \code{tooltipOptions}.}

\item{right}{Logical. The dropdown menu starts on the right.}

\item{up}{Logical. Display the dropdown menu above.}

\item{width}{Width of the dropdown menu content.}

\item{margin}{Value of the dropdown margin-right and margin-left menu content.}

\item{inputId}{Optional, id for the button, the button act like an \code{actionButton},
and you can use the id to toggle the dropdown menu server-side with \code{\link{toggleDropdownButton}}.}
}
\description{
Create a dropdown menu with Bootstrap where you can put input elements.
}
\details{
It is possible to know if a dropdown is open or closed server-side with \code{input$<inputId>_state}.
}
\note{
\code{pickerInput} doesn't work inside \code{dropdownButton} because that's also a
dropdown and you can't nest them. Instead use \code{\link{dropdown}},
it has similar features but is built differently so it works.
}
\examples{
\dontrun{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  dropdownButton(
    inputId = "mydropdown",
    label = "Controls",
    icon = icon("sliders"),
    status = "primary",
    circle = FALSE,
    sliderInput(
      inputId = "n",
      label = "Number of observations",
      min = 10, max = 100, value = 30
    ),
    prettyToggle(
      inputId = "na",
      label_on = "NAs keeped",
      label_off = "NAs removed",
      icon_on = icon("check"),
      icon_off = icon("remove")
    )
  ),
  tags$div(style = "height: 140px;"), # spacing
  verbatimTextOutput(outputId = "out"),
  verbatimTextOutput(outputId = "state")
)

server <- function(input, output, session) {

  output$out <- renderPrint({
    cat(
      " # n\\n", input$n, "\\n",
      "# na\\n", input$na
    )
  })

  output$state <- renderPrint({
    cat("Open:", input$mydropdown_state)
  })

}

shinyApp(ui, server)

}
}
}
