% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-materialswitch.R
\name{materialSwitch}
\alias{materialSwitch}
\title{Material Design Switch Input Control}
\usage{
materialSwitch(inputId, label = NULL, value = FALSE, status = "default",
  right = FALSE, width = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Input label.}

\item{value}{TRUE or FALSE.}

\item{status}{Color of the switch}

\item{right}{Should the the label be on the right ? default to FALSE}

\item{width}{Width of the container}
}
\value{
A switch control that can be added to a UI definition.
}
\description{
Create buttons grouped that act like radio buttons.
}
\examples{
materialSwitch(inputId = "somevalue", label = "")
\dontrun{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  materialSwitch(inputId = "somevalue", label = ""),
  verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- renderText({ input$somevalue })
}
shinyApp(ui, server)
}
}

}
