% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7PhotoBrowser.R
\name{f7PhotoBrowser}
\alias{f7PhotoBrowser}
\title{Framework7 photo browser}
\usage{
f7PhotoBrowser(
  photos,
  theme = c("light", "dark"),
  type = c("popup", "standalone", "page"),
  ...,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{photos}{List of photos}

\item{theme}{Browser theme: choose either light or dark.}

\item{type}{Browser type: choose among \code{c("popup", "standalone", "page")}.}

\item{...}{Other options.}

\item{session}{Shiny session object.}
}
\description{
A nice photo browser.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "f7PhotoBrowser",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7PhotoBrowser"),
       f7Button(inputId = "togglePhoto", "Open photo")
     )
   ),
   server = function(input, output, session) {
    observeEvent(input$togglePhoto, {
     f7PhotoBrowser(
         id = "photobrowser1",
         label = "Open",
         theme = "light",
         type = "standalone",
         photos = c(
           "https://cdn.framework7.io/placeholder/sports-1024x1024-1.jpg",
           "https://cdn.framework7.io/placeholder/sports-1024x1024-2.jpg",
           "https://cdn.framework7.io/placeholder/sports-1024x1024-3.jpg"
         )
       )
    })

   }
 )
}
}
