% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Messages.R
\name{f7Messages}
\alias{f7Messages}
\alias{f7Message}
\alias{f7AddMessages}
\alias{updateF7Messages}
\title{Framework7 messages container}
\usage{
f7Messages(
  id,
  title = NULL,
  autoLayout = TRUE,
  newMessagesFirst = FALSE,
  scrollMessages = TRUE,
  scrollMessagesOnEdge = TRUE
)

f7Message(
  text,
  name,
  type = c("sent", "received"),
  header = NULL,
  footer = NULL,
  avatar = NULL,
  textHeader = NULL,
  textFooter = NULL,
  image = NULL,
  imageSrc = NULL,
  cssClass = NULL
)

f7AddMessages(
  id,
  messages,
  showTyping = FALSE,
  session = shiny::getDefaultReactiveDomain()
)

updateF7Messages(
  id,
  messages,
  showTyping = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{Reference to link{f7Messages} container.}

\item{title}{Optional messages title.}

\item{autoLayout}{Enable Auto Layout to add all required additional classes
automatically based on passed conditions.}

\item{newMessagesFirst}{Enable if you want to use new messages on top,
instead of having them on bottom.}

\item{scrollMessages}{Enable/disable messages auto scrolling when adding new message.}

\item{scrollMessagesOnEdge}{If enabled then messages auto scrolling will happen only
when user is on top/bottom of the messages view.}

\item{text}{Message text.}

\item{name}{Sender name.}

\item{type}{Message type - sent or received.}

\item{header}{Single message header.}

\item{footer}{Single message footer.}

\item{avatar}{Sender avatar URL string.}

\item{textHeader}{Message text header.}

\item{textFooter}{Message text footer.}

\item{image}{Message image HTML string, e.g. <img src="path/to/image">. Can be used instead of imageSrc parameter.}

\item{imageSrc}{Message image URL string. Can be used instead of image parameter.}

\item{cssClass}{Additional CSS class to set on message HTML element.}

\item{messages}{List of \link{f7Messages}.}

\item{showTyping}{Show typing when a new message comes. Default to FALSE.
Does not work yet...}

\item{session}{Shiny session object}
}
\description{
\link{f7Messages} is an empty container targeted by \link{updateF7Messages}
to include multiple \link{f7Message}.

\link{f7Message} creates a message item to be inserted in
\link{f7Messages} with \link{updateF7Messages}.

Deprecated. \link{f7AddMessages} add messages to a \link{f7Messages} container.

\link{updateF7Messages} add messages to a \link{f7Messages} container.
}
\note{
\link{f7AddMessages} is deprecated. Use \link{updateF7Messages} instead.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
  ui = f7Page(
    title = "Messages",
    f7SingleLayout(
      navbar = f7Navbar(
        title = "Messages",
        hairline = FALSE,
        shadow = TRUE
      ),
      toolbar = f7MessageBar(inputId = "mymessagebar", placeholder = "Message"),
      # main content
      f7Messages(id = "mymessages", title = "My message")

    )
  ),
  server = function(input, output, session) {
    observe({
      print(input[["mymessagebar-send"]])
      print(input$mymessages)
    })
    observeEvent(input[["mymessagebar-send"]], {
      updateF7Messages(
        id = "mymessages",
        list(
         f7Message(
          text = input$mymessagebar,
          name = "David",
          type = "sent",
          header = "Message Header",
          footer = "Message Footer",
          textHeader = "Text Header",
          textFooter = "text Footer",
          avatar = "https://cdn.framework7.io/placeholder/people-100x100-7.jpg"
         )
        )
      )
    })

    observe({
      invalidateLater(5000)
      names <- c("Victor", "John")
      name <- sample(names, 1)

      updateF7Messages(
        id = "mymessages",
        list(
         f7Message(
          text = "Some message",
          name = name,
          type = "received",
          avatar = "https://cdn.framework7.io/placeholder/people-100x100-9.jpg"
         )
        )
      )
    })

  }
 )
}
}
