% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ace-tooltips.R
\name{aceTooltip}
\alias{aceTooltip}
\title{Enable Completion Tooltips for an Ace Code Input}
\usage{
aceTooltip(inputId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{inputId}{The id of the input object}

\item{session}{The \code{session} object passed to function given to
shinyServer}
}
\value{
An observer reference class object that is responsible for offering
  completion tooltips. See \code{\link[shiny]{observe}} for more details. You
  can use \code{suspend} or \code{destroy} to pause to stop dynamic code
  completion.

  The observer reference object will send a custom shiny message using
  \code{session$sendCustomMessage} to the docTooltip endpoint containing a
  json list of completion item metadata objects. The json list should have a
  structure akin to one of:

  A text object
  \preformatted{
  <str: text to display for tooltip>
  }

  An object containing a \code{docHTML} property
  \preformatted{
  {
     docHTML: <str: html to display for tooltip div, used if available>,
  }
  }

  An object containing a \code{docText} property
  \preformatted{
  {
     docText: <str: text to display for tooltip div>
  }
  }
}
\description{
This function uses the completion item object to retrieve tooltip information
by parsing R \code{\link{help}} documentation and rendering to html.
}
\details{
You can implement your own tooltips by observing modification events to
\code{input$<editorId>_shinyAce_tooltipItem} where <editorId> is the
\code{aceEditor} id. This input contains the object passed to codeCompletion
for this item. See the help for \code{\link{aceAutocomplete}} for details on
the fields of the completion item object.
}
