% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_point_process.R
\name{fit_point_process}
\alias{fit_point_process}
\title{fit_point_process}
\usage{
fit_point_process(pattern, n_random = 1, process = "poisson",
  return_input = TRUE, simplify = FALSE, verbose = TRUE)
}
\arguments{
\item{pattern}{List with reconstructed patterns.}

\item{n_random}{Number of randomized RasterLayers.}

\item{process}{What point process to use. Either 'poisson' or 'cluster'.}

\item{return_input}{The original input data is returned as last list entry.}

\item{simplify}{If n_random = 1 and return_input = FALSE only pattern will be returned.}

\item{verbose}{Print progress report.}
}
\value{
list
}
\description{
Create random patterns by point process fitting
}
\details{
The functions randomizes the observed pattern by fitting a point process to the data.
It is possible to choose between a Poisson process or a Thomas cluster process.
}
\examples{
pattern_fitted <- fit_point_process(pattern = species_a, n_random = 39)

}
\references{
Plotkin, J. B., Potts, M. D., Leslie, N., Manokaran, N., LaFrankie, J. V., & Ashton, P. S. (2000).
Species-area curves, spatial aggregation, and habitat specialization in tropical forests.
Journal of Theoretical Biology, 207(1), 81-99.
}
