% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.sgs}
\alias{print.sgs}
\title{Print a \code{"sgs"} object.}
\usage{
\method{print}{sgs}(x, ...)
}
\arguments{
\item{x}{Object an object of class \code{"sgs"} from a call to \code{\link[=fit_sgs]{fit_sgs()}} or \code{\link[=fit_sgs_cv]{fit_sgs_cv()}}.}

\item{...}{further arguments passed to base function.}
}
\value{
A summary of the model fit(s).
}
\description{
Performs prediction from an \code{\link[=fit_sgs]{fit_sgs()}} model fit.
}
\examples{
# specify a grouping structure
groups = c(rep(1:20, each=3),
          rep(21:40, each=4),
          rep(41:60, each=5),
          rep(61:80, each=6),
          rep(81:100, each=7))
# generate data
data =  gen_toy_data(p=500, n=400, groups = groups, seed_id=3)
# run SGS 
model = fit_sgs(X = data$X, y = data$y, groups = groups, type="linear", lambda = 1, alpha=0.95, 
vFDR=0.1, gFDR=0.1, standardise = "l2", intercept = TRUE, verbose=FALSE)
# print model
print(model)
}
\seealso{
\code{\link[=fit_sgs]{fit_sgs()}}, \code{\link[=fit_sgs_cv]{fit_sgs_cv()}}, \code{\link[=fit_gslope]{fit_gslope()}}, \code{\link[=fit_gslope_cv]{fit_gslope_cv()}}

Other SGS-methods: 
\code{\link{as_sgs}()},
\code{\link{coef.sgs}()},
\code{\link{fit_sgs}()},
\code{\link{fit_sgs_cv}()},
\code{\link{plot.sgs}()},
\code{\link{predict.sgs}()},
\code{\link{scaled_sgs}()}

Other gSLOPE-methods: 
\code{\link{coef.sgs}()},
\code{\link{fit_gslope}()},
\code{\link{fit_gslope_cv}()},
\code{\link{plot.sgs}()},
\code{\link{predict.sgs}()}
}
\concept{SGS-methods}
\concept{gSLOPE-methods}
