% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_tracker.R
\name{sst_rt_positions_history}
\alias{sst_rt_positions_history}
\title{Get ranking history for the domain or URL in selected search region}
\usage{
sst_rt_positions_history(
  api_token,
  project_id,
  region_id,
  date_from,
  date_to,
  keywords,
  url,
  sort = "keyword",
  order = "desc",
  page = 1,
  size = 100,
  return_method = "list"
)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{project_id}{(required) The ID of your project in Serpstat. You can
find this ID in the URL of any rank tracker report. As an example, in
https://serpstat.com/rank-tracker/keywords/12345/positions?get_params the
ID would be 12345.}

\item{region_id}{(required) The ID of a region returned by
\code{\link{sst_rt_project_regions}}.}

\item{date_from}{(optional) The date string in 'YYYY-MM-DD' format to
specify the initial date of retrieved data.}

\item{date_to}{(optional) The date string in 'YYYY-MM-DD' format to
specify the final date of retrieved data. Must not exceed date_from + 30
days.}

\item{keywords}{(optional) A vector of keywords for witch the data should be
retrieved. Maximum 1000 keywords per request.}

\item{url}{(optional) The domain name (e.g. domain.com) or web page address
(e.g. https://domain.com/page) to get the data for. BY default the
results are returned for the projects' domain name.}

\item{sort}{(optional) Must be one of 'keyword' (default) to sort the
results alphabetically or 'date' to sort the results by date.}

\item{order}{(optional) The sorting order. Must be one of string 'desc'
(default) for descending sorting or 'asc' for ascending sorting.}

\item{page}{(optional) Page number if there are many pages in response. The
default value is 1.}

\item{size}{(optional) Page size. Must be one of 20, 50, 100, 200, 500.The
default value is 100.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}
}
\value{
Returns positions of selected domain in search engine results in
  selected region with corresponding URLs for these positions.
}
\description{
This method method returns the rankings for specified domain is selected
  search region.
}
\section{API rows consumption}{
 0
}

\examples{
\dontrun{
api_token  <- 'api_token'
project_id <- 12345
region_id  <- sst_rt_project_regions(
  api_token  = api_token,
  project_id = project_id
  )$data$regions[[1]]$id
sst_rt_positions_history(
  api_token     = api_token,
  project_id    = project_id,
  region_id     = region_id,
  date_from     = '2020-12-01',
  date_to       = '2020-12-30',
  keywords      = c('seo', 'ppc', 'serpstat'),
  url           = 'serpstat.com',
  sort          = 'keyword',
  order         = 'desc',
  page          = 1,
  size          = 100,
  return_method = 'list'
)
}
}
