% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeSeries.R
\name{sentopics_date}
\alias{sentopics_date}
\alias{sentopics_date<-}
\title{Internal date}
\usage{
sentopics_date(x, include_docvars = FALSE)

sentopics_date(x) <- value
}
\arguments{
\item{x}{a \code{sentopicmodel} created from the \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}}, \code{\link[=rJST]{rJST()}} or
\code{\link[=sentopicmodel]{sentopicmodel()}} function}

\item{include_docvars}{if \code{TRUE} the function will return all docvars stored
in the internal \code{tokens} object of the model}

\item{value}{a \code{Date}-coercible vector of dates to input into the model.}
}
\value{
a data.frame with the stored date per document.
}
\description{
Extract or replace the internal dates of a \code{sentopicmodel}. The
internal dates are used to create time series using the functions
\code{\link[=sentiment_series]{sentiment_series()}} or \code{\link[=sentiment_topics]{sentiment_topics()}}. Dates should be provided by
using \code{sentopics_date(x) <- value} or by storing a '.date' docvars in
the \link{tokens} object used to create the model.
}
\note{
The internal date is stored internally in the \emph{docvars} of the topic
model. This means that dates may also be accessed through the \code{\link[=docvars]{docvars()}}
function, although this is discouraged.
}
\examples{
# example dataset already contains ".date" docvar
docvars(ECB_press_conferences_tokens)
# dates are automatically stored in the sentopicmodel object
lda <- LDA(ECB_press_conferences_tokens)
sentopics_date(lda)

# dates can be removed or modified by the assignment operator
sentopics_date(lda) <- NULL
sentopics_date(lda) <- docvars(ECB_press_conferences_tokens, ".date")
}
\seealso{
Other sentopics helpers: 
\code{\link{sentopics_labels}()},
\code{\link{sentopics_sentiment}()}
}
\author{
Olivier Delmarcelle
}
\concept{sentopics helpers}
