% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merging.R
\name{mergeTopics}
\alias{mergeTopics}
\title{Merge topics into fewer themes}
\usage{
mergeTopics(x, merging_list)
}
\arguments{
\item{x}{a \code{\link[=LDA]{LDA()}} or \code{\link[=rJST]{rJST()}} model.}

\item{merging_list}{a list where each element is an integer vector containing
the indices of topics to be merged. If named, the list's names become the
label of the aggregated themes.}
}
\value{
A \code{\link[=LDA]{LDA()}} or \code{\link[=rJST]{rJST()}} model with the merged topics.
}
\description{
This operation is especially useful for the analysis of the
model's output, by grouping together topics that share a common theme.
}
\details{
Topics are aggregated at the word assignment level. New
document-topic and topic-word probabilities are derived from the aggregated
assignments.

Note that the output of this function does not constitute an estimated
topic model, but merely an aggregation to ease the analysis. It is not
advised to use \code{\link[=fit.sentopicmodel]{fit()}} on the merged topic
model as it will radically affect the content and proportions of the new
themes.
}
\examples{
\donttest{lda <- LDA(ECB_press_conferences_tokens, K = 5)
lda <- fit(lda, 100)
merging_list <- list(
  c(1,5),
  2:4
)
mergeTopics(lda, merging_list)

# also possible with a named list
merging_list2 <- list(
  mytheme_1 = c(1,5),
  mytheme_2 = 2:4
)
merged <- mergeTopics(lda, merging_list2)
sentopics_labels(merged)

# implemented for rJST
rjst <- rJST(ECB_press_conferences_tokens, lexicon = LoughranMcDonald)
rjst <- fit(rjst, 100)
mergeTopics(rjst, merging_list2)}
}
\seealso{
sentopics_labels
}
