% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sentences.R
\name{get_sentences}
\alias{get_sentences}
\alias{get_sentences2}
\title{Get Sentences}
\usage{
get_sentences(x, ...)

get_sentences2(x, ...)
}
\arguments{
\item{x}{A character vector, \code{sentiment}, or \code{sentiment_by} object.}

\item{\ldots}{Ignored.}
}
\value{
Returns a list of vectors of sentences.
}
\description{
\code{get_sentences} - Get sentences from a character vector, \code{sentiment}, or
\code{sentiment_by} object. This is optimized for internal use, converting the
text to lower case and removing non-sentence boundary periods. \code{get_sentences2}
retains case and non-sentence boundary periods and should be preferable in
such instances where these features are deemed important to the analysis at
hand.

\code{get_sentences2} - Get sentences from a character vector but does not
force to lower case.
}
\examples{
(x <- paste0(
    "Mr. Brown comes! He says hello. i give him coffee.  i will ",
    "go at 5 p. m. eastern time.  Or somewhere in between!go there"
))
get_sentences(x)
get_sentences2(x)
}

