% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_constraint.R
\name{set_constraint}
\alias{set_constraint}
\title{Equality Constraint for Finding the LBCI by Wu-Neale-2012}
\usage{
set_constraint(sem_out, ciperc = 0.95)
}
\arguments{
\item{sem_out}{The SEM output. Currently supports
\link[lavaan:lavaan-class]{lavaan::lavaan} outputs only.}

\item{ciperc}{The intendeted coverage probability of the confidence
interval. Default is .95.}
}
\value{
An equality constraint function to be used by \code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}.
}
\description{
Create the equality constraint for finding the likelihood-based
confidence interval (LBCI) by the Wu-Neale-2012 method.
}
\details{
\subsection{Important Notice}{

This function is not supposed to be used directly by users in
typical scenarios. Its interface is user-\emph{unfriendly} because it
should be used through \code{\link[=semlbci]{semlbci()}}. It is exported such that
interested users can examine how a confidence bound is found, or
use it for experiments or simulations.
}

\subsection{Usage}{

The Wu-Neale-2012 method uses a simple objective function that is
optimized with an equality constraint. \code{\link[=set_constraint]{set_constraint()}} generates
the equality constraint function to be used by \code{\link[=ci_bound_wn_i]{ci_bound_wn_i()}}.

It currently supports \link[lavaan:lavaan-class]{lavaan::lavaan} outputs only.
}
}
\examples{

library(lavaan)
data(simple_med)
dat <- simple_med
mod <-
"
m ~ x
y ~ m
"
fit_med <- sem(mod, simple_med, fixed.x = FALSE)

fn_constr0 <- set_constraint(fit_med)
out <- fn_constr0(coef(fit_med), sem_out = fit_med)
out
lavTech(fit_med, "optim")$fx

}
