% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segclust.R
\name{segclust}
\alias{segclust}
\alias{segclust.data.frame}
\alias{segclust.Move}
\alias{segclust.ltraj}
\title{Segmentation/Clustering of movement data - Generic function}
\usage{
segclust(x, ...)

\method{segclust}{data.frame}(x, Kmax, lmin, ncluster, type = "behavior",
  seg.var = NULL, diag.var = seg.var, order.var = seg.var[1],
  coord.names = c("x", "y"), ...)

\method{segclust}{Move}(x, Kmax, lmin, ncluster, type = "behavior",
  seg.var = NULL, diag.var = seg.var, order.var = seg.var[1],
  coord.names = c("x", "y"), ...)

\method{segclust}{ltraj}(x, Kmax, lmin, ncluster, type = "behavior",
  seg.var = NULL, diag.var = seg.var, order.var = seg.var[1],
  coord.names = c("x", "y"), ...)
}
\arguments{
\item{x}{data used for segmentation. Supported: data.frame, Move object,
ltraj object}

\item{...}{additional parameters given to \code{\link{segclust_internal}}.}

\item{Kmax}{maximum number of segments.}

\item{lmin}{minimum length of segments.}

\item{ncluster}{number of cluster into which segments should be grouped. Can
be a vector if one want to test several number of clusters.}

\item{type}{type of segmentation. Either "home-range" or "behavior". Changes
default values of arguments order, scale.variable in the different
functions used on the output. Default for segmentation: "home-range";
default for segmentation/clustering : "behavior".}

\item{seg.var}{for behavioral segmentation: names of the variables used for
segmentation (either one or two names).}

\item{diag.var}{for behavioral segmentation: names of the variables on which
statistics are calculated.}

\item{order.var}{for behavioral segmentation: names of the variable with
which states are ordered.}

\item{coord.names}{for home-range segmentation and data.frame, names of coordinates. Default x and y. Not needed for move and ltraj objects}
}
\value{
a \code{\link{segmentation-class}} object
}
\description{
Joint Segmentation/Clustering of movement data. Method available for
data.frame, move and ltraj objects. The algorithm finds the optimal
segmentation for a given number of cluster and segments using an iterated
alternation of a Dynamic Programming algorithm and an
Expectation-Maximization algorithm. Among the different segmentation found,
the best one can be chosen using the maximum of a BIC penalized likelihood.
}
\examples{
#' @examples
df <-  test_data()$data
#' # data is a data.frame with column 'x' and 'y'
# Simple segmentation with automatic subsampling if data has more than 1000 rows:
res <- segclust(df, Kmax = 15, lmin = 10, ncluster = 2:4, seg.var = c("x","y"))
 # Plot results
 plot(res)
 segmap(res, coord.names = c("x","y"))
 # check penalized likelihood of alternative number of segment possible. There should
 # be a clear break if the segmentation is good
 plot_BIC(res)
\dontrun{
# Advanced options:
# Run with automatic subsampling if df has more than 500 rows:
res <- segclust(df, Kmax = 30, lmin = 10, ncluster = 2:4,
                seg.var = c("x","y"), subsample_over = 500)
# Run with subsampling by 2:
res <- segclust(df, Kmax = 30, lmin = 10, ncluster = 2:4,
                seg.var = c("x","y"), subsample_by = 2)
# Disable subsampling:
res <- segclust(df, Kmax = 30, lmin = 10, 
                ncluster = 2:4, seg.var = c("x","y"), subsample = FALSE)
# Disabling automatic scaling of variables for segmentation (standardazing the variables) :
 res <- segclust(df, Kmax = 30, lmin = 10,
                 seg.var = c("dist","angle"), scale.variable = FALSE)
}
}
