% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_safeObj.R
\docType{methods}
\name{get_safeobj}
\alias{get_safeobj}
\title{Query information from protected problem instances}
\usage{
get_safeobj(object, type, ...)
}
\arguments{
\item{object}{an object of class \linkS4class{sdcProblem}}

\item{type}{a character vector defining what should be returned. Possible
choices are:
\itemize{
\item \verb{"dimInfo}": get infos on dimensional variables that formed the base of the protected data
\item \verb{"finalData}": return final data object
\item \verb{"nrNonDuplicatedCells}": total number of cells that are duplicates
\item \verb{"nrPrimSupps}": total number of primary suppressed cells
\item \verb{"nrSecondSupps}": total number of secondary cell suppressions
\item \verb{"nrPublishableCells}": total number of cells that can be published
\item \verb{"suppMethod}": suppression method that has been used
\item \verb{"cellInfo}": extract information about a specific cell
\item \verb{"cellID}": calculate ID of a specific cell defined by level-codes and
variable names
}}

\item{...}{additional argument required for choices \code{"cellInfo"} and \code{"cellID"}
\itemize{
\item \code{"specs"}: a named character vector with names relating to the names of the
dimensional variables and values to levels of the hierarchies.
\item \code{"complete"}: if \code{TRUE}, the entire row is returned in \code{"cellID"}, otherwise
only the cell id (number)
\item \code{"verbose"}: toggles additional output
}}
}
\value{
the required information.
}
\description{
\code{\link[=get_safeobj]{get_safeobj()}} allows to extract information from protected \linkS4class{sdcProblem}
instances.
}
\note{
internal function
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
\keyword{internal}
