% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeJJFormat.R
\name{writeJJFormat}
\alias{writeJJFormat}
\title{Write a problem in jj-format to a file}
\usage{
writeJJFormat(x, tabvar = "freqs", path = "out.jj",
  overwrite = FALSE)
}
\arguments{
\item{x}{an input produced by \code{\link[=createJJFormat]{createJJFormat()}}}

\item{tabvar}{the name of the variable that will be used when producing the
problem in JJ format. It is possible to specify \code{freqs} (the default) or the
name of a numeric variable that was available in the \linkS4class{sdcProblem} object
used in \code{\link[=makeProblem]{makeProblem()}}.}

\item{path}{a scalar character defining the name of the file that
should be written. This can be an absolute or relative URL; however the file
must not exist.}

\item{overwrite}{logical scalar, if \code{TRUE} the file specified in \code{path} will
be overwritten if it exists}
}
\value{
invisibly the path to the file that was created.
}
\description{
This function allows to write a problem instance in
JJ-Format to a file.
}
\examples{
data("microData1", package = "sdcTable")

# create hierarchies
dimList <- list(
  region = hier_create(root = "Total", nodes = LETTERS[1:4]),
  gender = hier_create(root = "Total", nodes = c("male", "female")))

# create a problem instance
prob <- makeProblem(
  data = microData1,
  dimList = dimList,
  numVarInd = "val")

# create suitable input for `writeJJFormat`
inp <- createJJFormat(prob); inp

# write files to disk
# frequency table by default
writeJJFormat(inp, path = file.path(tempdir(), "prob_freqs.jj"), overwrite = TRUE)

# or using the numeric variable `val` previously specified
writeJJFormat(inp, tabvar = "val", path = file.path(tempdir(), "prob_val.jj"), overwrite = TRUE)
}
