% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.env.R
\name{reduce.env}
\alias{reduce.env}
\title{Reduce environmental data}
\usage{
reduce.env(env, transfer = NULL, occ_data, h.M = FALSE, mask, radio)
}
\arguments{
\item{env}{RasterStack* objet.}

\item{transfer}{List of rasterstack object}

\item{occ_data}{A data.frame of occurrence records.
It must include two column based on latitude and longitude.}

\item{h.M}{logical. If \code{TRUE}, called first
croping mask, (\code{default = FALSE}). This may be efficent
 in case where you have a "M" area.}

\item{mask}{Croped mask, must be shapefile (.shp), readOGR.}

\item{radio}{Radio value of buffer zone. Numeric > 0, Unit is kilometers.}
}
\value{
\code{@crop} RasterStack* Objet

 \code{@m.env} data.frame of environmental values to occurrence localities.
}
\description{
This function allows reduce environmental data clipping by mask or buffer area
}
\details{
Reduce the correlation among predicted variables either buffer zone, or
clipping mask.

Provide reduce objet with cut predicted variables and data.frame for
the values of each point of occurrence of them.
}
\examples{

# Phytotoma ocurrence data
data(phytotoma)

# Complement
library(dismo)
predictor <- stack(list.files(path=paste(system.file(package="dismo"),'/ex', sep=''),
 pattern='grd', full.names=TRUE ))
reduce_cut <- reduce.env(env = predictor, occ_data = phytotoma[,2:3],
h.M = FALSE, radio = 250)

# Plot reduce_cut
plot(reduce_cut@cropa$bio1)

# Add points
points(phytotoma[,2:3], pch=16,col='blue')

# Correlogram
cor.show(reduce_cut)
rd <- c('bio1','bio12','bio16','biome','bio8')

# Removing rd-variables on correlogram
cor.show(reduce_cut, rm=TRUE, var.rm = rd)

# Remove rd-variables
var_reduce <- dropLayer(reduce_cut@cropa, rd)

# summary
var_reduce


}
\seealso{
\code{\link{cor.show}}
}
