% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{readExperimentDir}
\alias{readExperimentDir}
\title{Read data from an experiment-like files in a directory}
\usage{
readExperimentDir(directory, names, fname.pattern, alg.var.name, value.col,
  col.names = NULL, ...)
}
\arguments{
\item{directory}{Directory with the files to load. It should only contain files to load, no other kind of file.}

\item{names}{List of names for the variables to be extracted from the file name}

\item{fname.pattern}{Regular expression to extract information from the file names. It has to be a regular expression that matches the name of the files and where the information to be extrcted has to be between brakets. As an example, to store the whole file name the expression \code{'([.]*)'} can be used. For more example see the examples below or the vignette covering the data loading.}

\item{alg.var.name}{Name of the variable that defines the algorithm used in the experiment. It can be either one of the variables extracted from the file name or the name of one of the columns in the file.}

\item{value.col}{Name or index (referred to the column in the file) of the column containing the results.}

\item{col.names}{Vector of names for the columns. If not provided (or \code{NULL}) the names will be read from the first line of the file.}

\item{...}{Additional parameters for the read.csv function used to load the data. It can be used, for example, to set the separator (e.g., \code{sep="\t"}). Note that the \code{header} argument is automatically set according to the \code{col.names} argument.}
}
\value{
A data.frame where each column represents either a feature of the experiment or the result of running an algorithm. Algorithm columns are placed always at the end of the table.
}
\description{
This function reads the data from all the files in a directory. Only one column of results is expected in each file. If the files contain the results of two or more algorithms, see function \code{\link{readComparisonFile}}. The function can extract information from the file name.
}
\details{
Note that all the files should have the same format (same number of columns and, in case they have, same header)
}
\examples{
dir <- paste(system.file("loading_tests",package="scmamp"), "experiment_files", sep="/")
# The format of the files is rgg_size_SIZE_r_RADIUS_ALGORITHM.out, where variables 
# to extract are in capital letters. 
list.files(dir)[1:5]
# The regular expresion can be as simple as substituting each variable name in the expression
# above by ([XXX]*), where XXX is the list of symbols that appear in the name.
pattern <- "rgg_size_([0-9]*)_r_(0.[0-9]*)_([a-z,A-Z,1,2]*).out"
var.names <- c("Size", "Radius", "Algorithm")
data <- readExperimentDir (directory=dir, names=var.names, fname.pattern=pattern, 
                           alg.var.name="Algorithm", value.col="Evaluation", 
                           col.names="Evaluation")
dim(data)
head(data)
}
\seealso{
\code{\link{readExperimentFile}}, \code{\link{readComparisonFile}}, \code{\link{readComparisonDir}} and the vignette \code{vignette(topic="Data_loading_and_manipulation", package="scmamp")}
}

