% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.ijdata.R
\name{convert.ijdata}
\alias{convert.ijdata}
\title{Convert IJDATA object to a list of spatstat objects}
\usage{
convert.ijdata(X)
}
\arguments{
\item{X}{an \code{\link[=read.ijdata]{IJDATA}} object to be converted.}
}
\value{
Returns a list of class \code{rawDist}, which contains \link[spatstat]{spatstat} point patterns. The returned \code{rawDist} can be plotted using the generic plotting command.
}
\description{
Converts an \code{\link[=read.ijdata]{IJDATA}} to a list of \link[spatstat]{spatstat} patterns ready for \link[=plot.rawDist]{plotting} or \link[=spot.dist]{sample spot alignment}.
}
\examples{
data(shellspots)
shell_map <- convert.ijdata(shellspots)
plot(shell_map)
}
\author{
Mikko Vihtakari
}
\seealso{
\code{\link{read.ijdata}} for generating \code{IJDATA} objects.

\code{\link{plot.rawDist}} for plotting.

\code{\link{spot.dist}} for aligning sample spots.
}

