% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.sort}
\alias{bursts.sort}
\title{Order a list of bursts by some function. For instance, popen.}
\usage{
bursts.sort(bursts, func, reverse = FALSE)
}
\arguments{
\item{bursts}{The list of all bursts}

\item{func}{A function of a segment that returns a numeric value}

\item{reverse}{By default, return in ascending order. Use reverse=TRUE to change that.}
}
\value{
A list sorted by func. By default in ascending order (unless reversed)
}
\description{
Order a list of bursts by some function. For instance, popen.
}
\examples{

infile <- system.file("extdata", "example1_qub.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")
bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

# A sorted list of bursts. 
sorted <- bursts.sort(bursts, segment.popen)

# You can also write your own functions. If you want P(Open) =~ P(Closed)
variance_fun <- function (seg) {
    # Any function that maps a segment to a number works.
    return(  segment.popen(seg) * segment.pclosed(seg)  )
}

weird_sort <- bursts.sort(bursts, variance_fun)

}
