% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_kernel_rgbwt.R
\name{apply_kernel_rgbwt}
\alias{apply_kernel_rgbwt}
\title{apply_kernel_rgbwt}
\usage{
apply_kernel_rgbwt(
  fRGBWT,
  filter = "circle",
  mask,
  radius = 2,
  sigma = radius/2,
  approx_limit = 3.5,
  threads = 0
)
}
\arguments{
\item{fRGBWT}{RGBWT matrix (\code{red}, \code{green}, \code{blue} channels, \code{weight} ~ sum of alphas,
\code{transparency} ~ 1 - alpha, dimension nxmx5).}

\item{filter}{Either \code{circle}, \code{square}, \code{gauss} or \code{own}, defaults to `circle.}

\item{mask}{Own kernel used for blurring, \code{filter} parameter has to be set to \code{own}.}

\item{radius}{Size of circle kernel, defaults to \code{2}.}

\item{sigma}{Parameter for gaussian filtering, defaults to \code{radius / 2}.}

\item{approx_limit}{Sets the size of the kernel, multiplied with \code{sigma}, defaults to \code{3.5}.}

\item{threads}{Number of parallel threads (default 0 chooses hardware concurrency).}
}
\value{
RGBWT matrix.
}
\description{
Blur given RGBWT matrix using \code{circle} or \code{gauss} filtering.
}
