% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_gene_preferences.R
\name{single_gene_preferences}
\alias{single_gene_preferences}
\title{Single cell-type gene preferences}
\usage{
single_gene_preferences(
  hg_short,
  hg_full,
  study_name,
  outDir,
  toSave = FALSE,
  path = NULL
)
}
\arguments{
\item{hg_short}{A list with two objects: a "preferences" and a "genesIn". Preferences is a list of gene symbols over-represented in each cell-type and genesIn were all the inputted genes.}

\item{hg_full}{The same as hg_short but for every gene in the signature matrix.}

\item{study_name}{Name of output table.}

\item{outDir}{Directory where table is outputted.}

\item{toSave}{Allow scMappR to write files in the current directory (T/F).}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}
}
\value{
\code{single_gene_preferences} A gene-set enrichment table of individual cell-type enrichment. \cr
}
\description{
Measure enrichment of individual cell-types in a signature matrix.
 
Internal function as part of tissue_scMappR_internal().
This function takes genes preferentially expressed within a gene list, each cell-type
and the background (i.e. all genes within the signature matrix) before completing 
the cell-type specific enrichment of the inputted gene list on each cell type.
This function then returns a table describing the cell-type enrichments (p-value and odds ratio)
of each cell-type.
}
\examples{
\donttest{

# load in signature matrices
data(POA_example)
POA_generes <- POA_example$POA_generes
POA_OR_signature <- POA_example$POA_OR_signature
POA_Rank_signature <- POA_example$POA_Rank_signature
sig <- get_gene_symbol(POA_Rank_signature)
Signature <- POA_Rank_signature
rownames(Signature) <- sig$rowname
genes <- rownames(Signature)[1:60]
heatmap_test <- tissue_scMappR_custom(gene_list = genes, signature_matrix = Signature,
                                      output_directory =  "scMappR_test", toSave = FALSE)
single_preferences <- heatmap_test$single_celltype_preferences
 }
}
